/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MyWeaponsTree
extends JTree {
    private final int CI = 0;
    private final int SW = 1;
    private final int SL = 2;
    private final int All = 3;
    private MyCustomMutableTreeNode rootNode;
    private String filename;
    public int clickX;
    public int clickY;
    PreAdders preAdders;
    MyItemAddMenu poppy;
    Adders adders;
    Mech theMech;
    public ArrayList<Item> itemList;
    BtMechBuilder window;
    int era;

    public MyWeaponsTree(BtMechBuilder btMechBuilder, Mech mech, MyCustomMutableTreeNode myCustomMutableTreeNode, String string) {
        super(myCustomMutableTreeNode);
        this.era = mech.era;
        this.theMech = mech;
        this.rootNode = myCustomMutableTreeNode;
        this.filename = string;
        this.createWeaponTreeNodes();
        this.adders = new Adders(btMechBuilder, mech);
        this.putClientProperty("JTree.lineStyle", "Horizontal");
        this.window = btMechBuilder;
        this.setCellRenderer(new MyCustomTreeCellRenderer());
        this.setToolTipText("Right-Click to add items");
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MyWeaponsTree.this.rightClicked(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    MyWeaponsTree.this.rightClicked(mouseEvent);
                }
            }
        });
    }

    private void rightClicked(MouseEvent mouseEvent) {
        this.clickY = mouseEvent.getY();
        this.clickX = mouseEvent.getX();
        Item item = this.getSelectedItem();
        if (item != null) {
            this.poppy = new MyItemAddMenu(this, this.adders, !this.theMech.isFourLegger);
            this.preAdders = new PreAdders(this.theMech, this.poppy);
            this.preAdders.pre(item, true);
            this.poppy.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public Item getSelectedItem() {
        TreePath treePath = this.getPathForLocation(this.clickX, this.clickY);
        if (treePath == null) {
            return null;
        }
        MyCustomMutableTreeNode myCustomMutableTreeNode = (MyCustomMutableTreeNode)treePath.getLastPathComponent();
        Object object = myCustomMutableTreeNode.getUserObject();
        if (!(object instanceof Item)) {
            return null;
        }
        return (Item)object;
    }

    @Override
    public TreePath getPathForLocation(int n, int n2) {
        return super.getPathForLocation(this.clickX, this.clickY);
    }

    private MyCustomMutableTreeNode createWeaponTreeNodes() {
        MyTextLine myTextLine;
        this.itemList = new ArrayList();
        MyCustomMutableTreeNode myCustomMutableTreeNode = null;
        Object var3_2 = null;
        MyTextReader myTextReader = new MyTextReader(this.filename);
        LinkedList<MyCustomMutableTreeNode> linkedList = new LinkedList<MyCustomMutableTreeNode>();
        linkedList.add(this.rootNode);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while ((myTextLine = myTextReader.nextLine()) != null) {
            String string = myTextLine.nextToken();
            if (string.equals("{")) {
                linkedList.push(new MyCustomMutableTreeNode((Object)myTextLine.nextToken(), myTextLine.nextToken()));
                continue;
            }
            if (string.equals("}")) {
                myCustomMutableTreeNode = (MyCustomMutableTreeNode)linkedList.pop();
                ((MyCustomMutableTreeNode)linkedList.peek()).add(myCustomMutableTreeNode);
                continue;
            }
            Item item = new Item(string);
            item.techBase = myTextLine.nextToken();
            item.name = myTextLine.nextToken();
            item.heat = myTextLine.nextToken();
            item.damage = myTextLine.nextToken();
            item.min = myTextLine.nextToken();
            item.sht = myTextLine.nextToken();
            item.med = myTextLine.nextToken();
            item.lng = myTextLine.nextToken();
            item.ammoPerTon = myTextLine.nextToken();
            item.weight = myTextLine.nextToken();
            item.crits = myTextLine.nextToken();
            item.cost = myTextLine.nextToken();
            item.bv = myTextLine.nextToken();
            item.eras[2] = myTextLine.nextToken();
            item.eras[1] = myTextLine.nextToken();
            item.eras[0] = myTextLine.nextToken();
            try {
                item.mtfRulesLevel = Integer.parseInt(myTextLine.nextToken());
                item.directFire = Integer.parseInt(myTextLine.nextToken());
                item.isAmmo = myTextLine.nextToken().equals("1");
                item.isWeapon = myTextLine.nextToken().equals("1");
                item.showInList = myTextLine.nextToken().equals("1");
                while ((string = myTextLine.nextToken()) != null) {
                    item.ammoTypes.add(string);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage() + "\n" + myTextLine.toString());
            }
            MyCustomMutableTreeNode myCustomMutableTreeNode2 = new MyCustomMutableTreeNode((Object)item, item.techBase);
            this.itemList.add(item);
            if (item.eras[0].equals("2") || this.era != 3 && !item.eras[this.era].equals("1")) continue;
            myCustomMutableTreeNode = (MyCustomMutableTreeNode)linkedList.peek();
            myCustomMutableTreeNode.add(myCustomMutableTreeNode2);
        }
        while (linkedList.size() > 1) {
            myCustomMutableTreeNode = (MyCustomMutableTreeNode)linkedList.pop();
            ((MyCustomMutableTreeNode)linkedList.peek()).add(myCustomMutableTreeNode);
        }
        this.expandPath(new TreePath(this.rootNode));
        return this.rootNode;
    }
}

