/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class MyDrawPanel
extends JPanel {
    private final int H = 0;
    private final int LT = 1;
    private final int CT = 2;
    private final int RT = 3;
    private final int LA = 4;
    private final int RA = 5;
    private final int LL = 6;
    private final int RL = 7;
    private final int rLT = 8;
    private final int rCT = 9;
    private final int rRT = 10;
    Color writeCol = new Color(96, 96, 144);
    Color dotCol = new Color(100, 112, 100);
    Font writeFont = new Font("SansSerif", 1, 12);
    CoordNode[][] structure = new CoordNode[8][31];
    CoordNode[][] armour = new CoordNode[11][62];
    CoordNode[] heat = new CoordNode[30];
    CoordNode type;
    CoordNode omni;
    CoordNode walking;
    CoordNode running;
    CoordNode jumping;
    CoordNode masc;
    CoordNode tsm;
    CoordNode cost;
    CoordNode bv;
    CoordNode tonnage;
    CoordNode clan;
    CoordNode innerSphere;
    CoordNode heatSinks;
    CoordNode singleHS;
    CoordNode doubleHS;
    CoordNode customImage;
    CoordNode heatCapacity;
    CoordNode maxDamage;
    CoordNode thirdGyroHit;
    int equipHeight;
    CoordNode equipmentList;
    int critHeight;
    CoordNode[] locations;
    CoordNode[] structPoints = new CoordNode[8];
    CoordNode[] armourPoints = new CoordNode[11];
    CoordNode gridLoc;
    CoordNode oppositeGridLoc;
    CoordNode gridSize;
    int resolution;
    int internStructDotSize;
    int armourDotSize;
    int heatSinkDotSize;
    double sin30;
    double cos30;
    CoordNode queHead;
    CoordNode queTail;
    private String formImageName;
    private String formLocsName;
    public BufferedImage img;
    public BufferedImage cleanImg;
    MyItemRemoveMenu poppy;
    Adders adders;
    Removers removers;
    public int clickX;
    public int clickY;
    PreRemovers preRemovers;
    PreAdders preAdders;
    Mech theMech;
    MyDiagPanel diagPan;
    BufferedImage fluffImg;
    private final int customImgSizeX = 167;
    private final int customImgSizeY = 175;
    File loadPath;

    MyDrawPanel(String string, String string2, MyDiagPanel myDiagPanel) {
        this.locations = new CoordNode[8];
        this.sin30 = Math.sin(0.5585053606381855);
        this.cos30 = Math.cos(0.5585053606381855);
        this.diagPan = myDiagPanel;
        this.changeImage(string, string2);
        this.loadPath = new File(".");
    }

    public void setMech(BtMechBuilder btMechBuilder, Mech mech) {
        this.theMech = mech;
        this.adders = new Adders(btMechBuilder, mech);
        this.removers = new Removers(btMechBuilder, mech);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MyDrawPanel.this.clickY = mouseEvent.getY();
                MyDrawPanel.this.clickX = mouseEvent.getX();
                if (MyDrawPanel.this.clickX > MyDrawPanel.this.customImage.x && MyDrawPanel.this.clickX < MyDrawPanel.this.customImage.x + 167 && MyDrawPanel.this.clickY > MyDrawPanel.this.customImage.y && MyDrawPanel.this.clickY < MyDrawPanel.this.customImage.y + 175) {
                    MyDrawPanel.this.loadFluff();
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    MyDrawPanel.this.rightClicked(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MyDrawPanel.this.clickY = mouseEvent.getY();
                MyDrawPanel.this.clickX = mouseEvent.getX();
                if (MyDrawPanel.this.clickX > MyDrawPanel.this.customImage.x && MyDrawPanel.this.clickX < MyDrawPanel.this.customImage.x + 167 && MyDrawPanel.this.clickY > MyDrawPanel.this.customImage.y && MyDrawPanel.this.clickY < MyDrawPanel.this.customImage.y + 175) {
                    MyDrawPanel.this.loadFluff();
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    MyDrawPanel.this.rightClicked(mouseEvent);
                }
            }
        });
    }

    private void rightClicked(MouseEvent mouseEvent) {
        int n = this.getSelectedLoc();
        int n2 = this.getSelectedMount(n);
        if (n != -1 && n2 != -1) {
            Loc loc = this.theMech.locs[n];
            if (loc.crits[n2] != null && !loc.crits[n2].permanent && !loc.crits[n2].getHead().split) {
                if (loc.crits[n2].size == -1) {
                    n2 = loc.getHeadNum(n2);
                }
                this.poppy = new MyItemRemoveMenu(this.removers, this.adders, n2, loc, !this.theMech.isFourLegger);
                this.preRemovers = new PreRemovers(this.theMech, this.poppy);
                this.preAdders = new PreAdders(this.theMech, this.poppy);
                this.preAdders.pre(loc.crits[n2].i, false);
                this.preRemovers.pre(loc.crits[n2], n);
                this.poppy.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public int getSelectedLoc() {
        int n = this.clickY - 3;
        for (int i = 0; i < 8; ++i) {
            if (this.clickX < this.locations[i].x - 10 || this.clickX > this.locations[i].x + 130 || n > this.locations[i].y + (this.theMech.locCrits[i] - 1) * this.critHeight || n <= this.locations[i].y - this.critHeight) continue;
            return i;
        }
        return -1;
    }

    public int getSelectedMount(int n) {
        int n2 = this.clickY - 3;
        if (n == -1) {
            return -1;
        }
        int n3 = n2 - this.locations[n].y;
        int n4 = n3 <= 0 ? 0 : n3 / this.critHeight + 1;
        if (n == 0 && this.theMech.cockpit.equals("Standard")) {
            if (n4 == 3) {
                n4 = 5;
            } else if (n4 == 4) {
                n4 = 3;
            } else if (n4 == 5) {
                n4 = 4;
            }
        }
        return n4;
    }

    public void floodRadar(CoordNode coordNode, int n, Color color, int n2) {
        this.diagPan.floodRadar(coordNode, n, color, n2);
    }

    public void drawThirdGyroHit() {
        Graphics2D graphics2D = this.img.createGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Ellipse2D.Double(this.thirdGyroHit.x, this.thirdGyroHit.y, 8.0, 8.0));
        graphics2D.dispose();
    }

    public void fillArmourCircle(int n, int n2) {
        if (n2 >= 62) {
            return;
        }
        Graphics2D graphics2D = this.img.createGraphics();
        graphics2D.setColor(Color.black);
        int n3 = -1;
        if (n == 2 || n == 10 || n == 8) {
            --n3;
        } else if (n == 9) {
            n3 -= 2;
        }
        graphics2D.draw(new Ellipse2D.Double(this.armour[n][n2].x, this.armour[n][n2].y, this.armourDotSize + n3, this.armourDotSize + n3));
        graphics2D.dispose();
    }

    public void fillHeatCircle(int n) {
        if (n >= 30) {
            return;
        }
        Graphics2D graphics2D = this.img.createGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Ellipse2D.Double(this.heat[n].x, this.heat[n].y, this.heatSinkDotSize - 1, this.heatSinkDotSize - 1));
        graphics2D.dispose();
    }

    public void fillStructureCircle(int n, int n2) {
        if (n2 >= 31) {
            return;
        }
        Graphics2D graphics2D = this.img.createGraphics();
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Ellipse2D.Double(this.structure[n][n2].x, this.structure[n][n2].y, this.internStructDotSize - 1, this.internStructDotSize - 1));
        graphics2D.dispose();
    }

    public void writeAmrPoints(int n, int n2) {
        this.addTextToImg("" + n2, this.armourPoints[n], this.writeCol);
    }

    public void writeStructPoints(int n, int n2) {
        this.addTextToImg("" + n2, this.structPoints[n], this.writeCol);
    }

    public void writeCrit(int n, int n2, String string, Color color) {
        this.addTextToImg(string, new CoordNode(this.locations[n].x, this.locations[n].y + n2 * this.critHeight), color, new Font("SansSerif", 1, 11));
    }

    public void writeEquipment(int n, String string) {
        this.addTextToImg(string, new CoordNode(this.equipmentList.x, this.equipmentList.y + n * this.equipHeight), Color.black, new Font("Lucida Sans TypeWriter", 0, 10));
    }

    public void loadFluff() {
        int n;
        int n2;
        try {
            JFileChooser jFileChooser = new JFileChooser(this.loadPath);
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    String string = file.getName().toLowerCase();
                    return string.endsWith(".gif") || string.endsWith(".jpg") || string.endsWith(".png") || string.endsWith(".bmp") || string.endsWith(".jpeg") || file.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Image files";
                }
            });
            if (jFileChooser.showOpenDialog(this) != 0) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            this.loadPath = file.getParentFile();
            this.fluffImg = ImageIO.read(file);
        }
        catch (Exception exception) {
            System.out.println("File load failed: " + exception.getMessage());
            return;
        }
        double d = 167.0 / (double)this.fluffImg.getWidth();
        double d2 = 175.0 / (double)this.fluffImg.getHeight();
        double d3 = Math.min(d, d2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d, d2);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        this.fluffImg = affineTransformOp.filter(this.fluffImg, null);
        for (n2 = 0; n2 < 167; ++n2) {
            for (n = 0; n < 175; ++n) {
                this.cleanImg.setRGB(this.customImage.x + n2, this.customImage.y + n, Color.white.getRGB());
                this.img.setRGB(this.customImage.x + n2, this.customImage.y + n, Color.white.getRGB());
            }
        }
        for (n2 = 0; n2 < 167; ++n2) {
            for (n = 0; n < 175; ++n) {
                this.cleanImg.setRGB(this.customImage.x + n2, this.customImage.y + n, this.fluffImg.getRGB(n2, n));
                this.img.setRGB(this.customImage.x + n2, this.customImage.y + n, this.fluffImg.getRGB(n2, n));
            }
        }
        this.repaint();
    }

    static BufferedImage deepCopy(BufferedImage bufferedImage) {
        ColorModel colorModel = bufferedImage.getColorModel();
        boolean bl = colorModel.isAlphaPremultiplied();
        WritableRaster writableRaster = bufferedImage.copyData(null);
        return new BufferedImage(colorModel, writableRaster, bl, null);
    }

    public void changeImage(String string, String string2) {
        this.formImageName = string;
        this.formLocsName = string2;
        this.loadImg();
        this.loadFormLocations();
        this.repaint();
    }

    public int getPixel(int n, int n2) {
        if (this.img == null) {
            return Color.black.getRGB();
        }
        return this.img.getRGB(n, n2);
    }

    private void loadFormLocations() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        MyTextReader myTextReader = new MyTextReader(this.formLocsName);
        MyTextLine myTextLine = myTextReader.nextLine();
        this.type = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.omni = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.walking = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.running = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.jumping = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.masc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.tsm = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.cost = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.bv = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.tonnage = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.clan = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.innerSphere = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.heatSinks = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.singleHS = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.doubleHS = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.customImage = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.heatCapacity = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.maxDamage = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.thirdGyroHit = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.equipHeight = myTextLine.nextInt();
        myTextLine = myTextReader.nextLine();
        this.equipmentList = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.critHeight = myTextLine.nextInt();
        for (n8 = 0; n8 < 8; ++n8) {
            myTextLine = myTextReader.nextLine();
            this.locations[n8] = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        }
        for (n8 = 0; n8 < 8; ++n8) {
            myTextLine = myTextReader.nextLine();
            this.structPoints[n8] = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        }
        for (n8 = 0; n8 < 11; ++n8) {
            myTextLine = myTextReader.nextLine();
            this.armourPoints[n8] = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        }
        int[] nArray = new int[]{3, 1, 2, 5, 4, 7, 6, 0, 9, 10, 8};
        for (n7 = 0; n7 < 7; ++n7) {
            n6 = nArray[n7];
            n5 = -1;
            if (n6 == 1 || n6 == 4 || n6 == 6) {
                n5 = nArray[n7 - 1];
            }
            if (n6 == 3 || n6 == 5 || n6 == 7) {
                myTextLine = myTextReader.nextLine();
                this.oppositeGridLoc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
                continue;
            }
            myTextLine = myTextReader.nextLine();
            this.gridLoc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
            myTextLine = myTextReader.nextLine();
            this.gridSize = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
            myTextLine = myTextReader.nextLine();
            this.internStructDotSize = this.resolution = myTextLine.nextInt();
            n4 = 31;
            for (n3 = 0; n3 < this.gridSize.y; ++n3) {
                myTextLine = myTextReader.nextLine();
                for (n2 = 0; n2 < this.gridSize.x; ++n2) {
                    if (myTextLine.getCharInt(n2) != 1) continue;
                    this.structure[n6][--n4] = new CoordNode(this.gridLoc.x + n2 * this.resolution, this.gridLoc.y + n3 * this.resolution);
                    if (n5 <= -1) continue;
                    n = this.oppositeGridLoc.x + (this.gridSize.x - 1 - n2) * this.resolution;
                    this.structure[n5][n4] = new CoordNode(n, this.gridLoc.y + n3 * this.resolution);
                }
            }
            for (n3 = n4; n3 < 31; ++n3) {
                this.structure[n6][n3 - n4] = this.structure[n6][n3];
            }
            if (n5 <= -1) continue;
            for (n3 = n4; n3 < 31; ++n3) {
                this.structure[n5][n3 - n4] = this.structure[n5][n3];
            }
        }
        for (n7 = 0; n7 < 11; ++n7) {
            n6 = nArray[n7];
            n5 = -1;
            if (n6 == 1 || n6 == 4 || n6 == 6 || n6 == 8) {
                n5 = nArray[n7 - 1];
            }
            if (n6 == 3 || n6 == 5 || n6 == 7 || n6 == 10) {
                myTextLine = myTextReader.nextLine();
                this.oppositeGridLoc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
                continue;
            }
            myTextLine = myTextReader.nextLine();
            this.gridLoc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
            myTextLine = myTextReader.nextLine();
            this.gridSize = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
            myTextLine = myTextReader.nextLine();
            this.resolution = myTextLine.nextInt();
            if (n6 == 4) {
                this.armourDotSize = this.resolution;
            }
            n4 = 62;
            for (n3 = 0; n3 < this.gridSize.y; ++n3) {
                myTextLine = myTextReader.nextLine();
                for (n2 = 0; n2 < this.gridSize.x; ++n2) {
                    if (myTextLine.getCharInt(n2) != 1) continue;
                    this.armour[n6][--n4] = new CoordNode(this.gridLoc.x + n2 * this.resolution, this.gridLoc.y + n3 * this.resolution);
                    if (n5 <= -1) continue;
                    n = this.oppositeGridLoc.x + (this.gridSize.x - 1 - n2) * this.resolution;
                    this.armour[n5][n4] = new CoordNode(n, this.gridLoc.y + n3 * this.resolution);
                }
            }
            for (n3 = n4; n3 < 62; ++n3) {
                this.armour[n6][n3 - n4] = this.armour[n6][n3];
            }
            if (n5 <= -1) continue;
            for (n3 = n4; n3 < 62; ++n3) {
                this.armour[n5][n3 - n4] = this.armour[n5][n3];
            }
        }
        myTextLine = myTextReader.nextLine();
        this.gridLoc = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.gridSize = new CoordNode(myTextLine.nextInt(), myTextLine.nextInt());
        myTextLine = myTextReader.nextLine();
        this.heatSinkDotSize = this.resolution = myTextLine.nextInt();
        n7 = 30;
        for (n6 = 0; n6 < this.gridSize.y; ++n6) {
            myTextLine = myTextReader.nextLine();
            for (n5 = 0; n5 < this.gridSize.x; ++n5) {
                if (myTextLine.getCharInt(n5) != 1) continue;
                this.heat[--n7] = new CoordNode(this.gridLoc.x + n5 * this.resolution, this.gridLoc.y + n6 * this.resolution);
            }
        }
    }

    public void refreshImage() {
        this.img = MyDrawPanel.deepCopy(this.cleanImg);
        this.diagPan.loadImg();
        this.repaint();
    }

    public void loadImg() {
        try {
            this.img = ImageIO.read(new File(this.formImageName));
        }
        catch (Exception exception) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.formImageName);
                this.img = ImageIO.read(inputStream);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.cleanImg = MyDrawPanel.deepCopy(this.img);
        this.diagPan.loadImg();
        this.repaint();
    }

    public void saveImg(String string) {
        try {
            File file = new File(string + ".png");
            ImageIO.write((RenderedImage)this.img, "png", file);
        }
        catch (Exception exception) {
            System.out.println("oh shit, save failed!");
        }
    }

    public void addTextToImg(String string, CoordNode coordNode) {
        this.addTextToImg(string, coordNode.x, coordNode.y, this.writeCol, this.writeFont);
    }

    public void addTextToImg(String string, CoordNode coordNode, Font font) {
        this.addTextToImg(string, coordNode.x, coordNode.y, this.writeCol, font);
    }

    public void addTextToImg(String string, CoordNode coordNode, Color color) {
        this.addTextToImg(string, coordNode.x, coordNode.y, color, this.writeFont);
    }

    public void addTextToImg(String string, CoordNode coordNode, Color color, Font font) {
        this.addTextToImg(string, coordNode.x, coordNode.y, color, font);
    }

    public void addTextToImg(String string, int n, int n2, Color color, Font font) {
        if (n2 > 963) {
            return;
        }
        Graphics2D graphics2D = this.img.createGraphics();
        graphics2D.setFont(font);
        graphics2D.setColor(color);
        ((Graphics)graphics2D).drawString(string, n, n2);
        graphics2D.dispose();
    }

    private void floodFill(CoordNode coordNode, Color color) {
        this.floodFill(coordNode.x, coordNode.y, color.getRGB(), this.getPixel(coordNode.x, coordNode.y));
    }

    private void floodFill(int n, int n2, int n3, int n4) {
        CoordNode coordNode;
        if (n3 == n4) {
            ++n4;
        }
        this.queTail = this.queHead = (coordNode = new CoordNode(n, n2));
        if (this.img.getRGB(coordNode.x, coordNode.y) != n4) {
            return;
        }
        while (this.queHead != null) {
            CoordNode coordNode2 = this.queHead;
            if (this.img.getRGB(coordNode2.x, coordNode2.y) == n4) {
                this.img.setRGB(coordNode2.x, coordNode2.y, n3);
                if (coordNode2.x - 1 >= 0 && this.img.getRGB(coordNode2.x - 1, coordNode2.y) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x - 1, coordNode2.y);
                }
                if (coordNode2.x + 1 < this.img.getWidth() && this.img.getRGB(coordNode2.x + 1, coordNode2.y) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x + 1, coordNode2.y);
                }
                if (coordNode2.y + 1 < this.img.getHeight() && this.img.getRGB(coordNode2.x, coordNode2.y + 1) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x, coordNode2.y + 1);
                }
                if (coordNode2.y - 1 >= 0 && this.img.getRGB(coordNode2.x, coordNode2.y - 1) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x, coordNode2.y - 1);
                }
            }
            this.queHead = coordNode2.next;
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.img, 0, 0, null);
        this.diagPan.repaint();
    }
}

