/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

public class MyDiagPanel
extends JPanel {
    String path;
    double sin30;
    double cos30;
    public BufferedImage img;
    CoordNode queHead;
    CoordNode queTail;

    public MyDiagPanel(String string) {
        this.path = string;
        this.sin30 = Math.sin(0.5585053606381855);
        this.cos30 = Math.cos(0.5585053606381855);
        this.loadImg();
    }

    public void loadImg() {
        try {
            this.img = ImageIO.read(new File(this.path));
        }
        catch (Exception exception) {
            try {
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.path);
                this.img = ImageIO.read(inputStream);
            }
            catch (Exception exception2) {
                System.out.println("$$$ failed to load " + this.path);
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.img, 0, 0, null);
    }

    public int getPixel(int n, int n2) {
        if (this.img == null) {
            return Color.black.getRGB();
        }
        return this.img.getRGB(n, n2);
    }

    public void floodRadar(CoordNode coordNode, int n, Color color, int n2) {
        CoordNode coordNode2 = new CoordNode(coordNode.x, coordNode.y);
        switch (n) {
            case 0: {
                coordNode2.x = coordNode.x + (int)((double)(2 + n2 * 4) * this.cos30);
                coordNode2.y = coordNode.y + (int)((double)(-1 * (2 + n2 * 4)) * this.sin30);
                if (n2 > 1) {
                    this.floodFill(coordNode2, color);
                }
                coordNode2.y = coordNode.y - 2 - n2 * 4;
                coordNode2.x = coordNode.x;
                break;
            }
            case 1: {
                coordNode2.y = coordNode.y;
                coordNode2.x = coordNode.x - 2 - n2 * 4;
                break;
            }
            case 2: {
                coordNode2.y = coordNode.y;
                coordNode2.x = coordNode.x + 1 + n2 * 4;
            }
        }
        this.floodFill(coordNode2, color);
    }

    private void floodFill(CoordNode coordNode, Color color) {
        this.floodFill(coordNode.x, coordNode.y, color.getRGB(), this.getPixel(coordNode.x, coordNode.y));
    }

    private void floodFill(int n, int n2, int n3, int n4) {
        CoordNode coordNode;
        if (n3 == n4) {
            ++n4;
        }
        this.queTail = this.queHead = (coordNode = new CoordNode(n, n2));
        if (this.img.getRGB(coordNode.x, coordNode.y) != n4) {
            return;
        }
        while (this.queHead != null) {
            CoordNode coordNode2 = this.queHead;
            if (this.img.getRGB(coordNode2.x, coordNode2.y) == n4) {
                this.img.setRGB(coordNode2.x, coordNode2.y, n3);
                if (coordNode2.x - 1 >= 0 && this.img.getRGB(coordNode2.x - 1, coordNode2.y) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x - 1, coordNode2.y);
                }
                if (coordNode2.x + 1 < this.img.getWidth() && this.img.getRGB(coordNode2.x + 1, coordNode2.y) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x + 1, coordNode2.y);
                }
                if (coordNode2.y + 1 < this.img.getHeight() && this.img.getRGB(coordNode2.x, coordNode2.y + 1) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x, coordNode2.y + 1);
                }
                if (coordNode2.y - 1 >= 0 && this.img.getRGB(coordNode2.x, coordNode2.y - 1) == n4) {
                    this.queTail = this.queTail.next = new CoordNode(coordNode2.x, coordNode2.y - 1);
                }
            }
            this.queHead = coordNode2.next;
        }
        this.repaint();
    }
}

