/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JLabel;

public class Mech {
    private final int H = 0;
    private final int LT = 1;
    private final int CT = 2;
    private final int RT = 3;
    private final int LA = 4;
    private final int RA = 5;
    private final int LL = 6;
    private final int RL = 7;
    private final int rLT = 8;
    private final int rCT = 9;
    private final int rRT = 10;
    private final int CI = 0;
    private final int SW = 1;
    private final int SL = 2;
    private final int All = 3;
    private final int listNameLength = 20;
    public final Color defaultCol = new Color(64, 64, 64);
    public final Color permanentCol = new Color(128, 128, 128);
    public final Color semiPermCol = new Color(128, 128, 128);
    public final Color movableCol = new Color(64, 128, 64);
    public final Color weaponCol = new Color(128, 64, 64);
    public final Color nonWeapCol = new Color(64, 64, 128);
    public final Color ammoCol = new Color(128, 64, 128);
    public final Color damColMax = new Color(0, 0, 0);
    public final Color damColHigh = new Color(255, 0, 0);
    public final Color damColMed = new Color(255, 255, 0);
    public final Color damColLow = new Color(0, 192, 0);
    public final Color damColVeryLow = new Color(64, 64, 255);
    public final Color damColOne = new Color(192, 192, 255);
    public final Color heatColMax = new Color(0, 0, 64);
    public final Color heatColHigh = new Color(0, 0, 255);
    public final Color heatColMed = new Color(0, 192, 0);
    public final Color heatColLow = new Color(255, 255, 0);
    public final Color heatColVeryLow = new Color(255, 128, 0);
    public final Color heatColOne = new Color(255, 0, 0);
    private final int damLev1 = 1;
    private final int damLev2 = 5;
    private final int damLev3 = 10;
    private final int damLev4 = 20;
    private final int damLev5 = 50;
    private final int damLev6 = 100;
    private final int heatLev1 = 1;
    private final int heatLev2 = 50;
    private final int heatLev3 = 75;
    private final int heatLev4 = 100;
    private final int heatLev5 = 110;
    private final int heatLev6 = 500;
    private final int[] structMaxes2leg = new int[]{3, 21, 31, 21, 17, 17, 21, 21, 21, 31, 21};
    private final int[] structMaxes4leg = new int[]{3, 21, 31, 21, 21, 21, 21, 21, 21, 31, 21};
    public String name;
    public String variant;
    public boolean isClan;
    public boolean isFourLegger;
    public boolean isOmni;
    public double tonnage;
    public double currWeight;
    public int[] internalStructPts;
    public int[] locCrits;
    public boolean endo;
    public int walk;
    public int run;
    public int jump;
    public int engineRating;
    public String engineType;
    public double engineMass;
    public String gyro;
    public double gyroMass;
    public boolean improvedJJ;
    public String cockpit;
    public boolean tsm;
    public boolean doubleHS;
    public boolean leftArm;
    public boolean leftHand;
    public boolean rightArm;
    public boolean rightHand;
    public String armour;
    public int maxArmour;
    public double maxArmTons;
    public double armourTons;
    public int armourPts;
    public int[] locMaxArmour;
    public int[] locArmour;
    public int sinks;
    public boolean targComp;
    public int era;
    public int mtfRulesLevel;
    public Loc[] locs;
    public ArrayList<Mount> mounts;
    public GetTonners getTon;
    public GetHeaters getHeat;
    public GetDamagers getDam;
    public GetCriters getCrit;
    public GetRangers getRange;
    public GetBVers getBV;
    public GetCosters getCost;
    public Removers remover;
    public JLabel msgLabel;
    private MyDrawPanel mdp;
    public BtMechBuilder window;

    public Mech(JLabel jLabel, MyDrawPanel myDrawPanel, BtMechBuilder btMechBuilder) {
        this.window = btMechBuilder;
        this.remover = new Removers(this.window, this);
        this.mdp = myDrawPanel;
        this.msgLabel = jLabel;
        this.getTon = new GetTonners(this);
        this.getCost = new GetCosters(this);
        this.getHeat = new GetHeaters();
        this.getDam = new GetDamagers(this);
        this.getCrit = new GetCriters(this);
        this.getBV = new GetBVers(this);
        this.getRange = new GetRangers(this);
        this.internalStructPts = new int[11];
        this.locCrits = new int[11];
        this.locMaxArmour = new int[11];
        this.locArmour = new int[11];
        this.mounts = new ArrayList();
        this.locs = new Loc[8];
        this.name = "Name";
        this.variant = "Variant";
        this.isClan = false;
        this.isFourLegger = false;
        this.isOmni = false;
        this.tonnage = 20.0;
        this.era = 0;
        this.mtfRulesLevel = 1;
        this.clear();
    }

    public int calcMtfRulesLevel() {
        this.mtfRulesLevel = 1;
        if (this.isClan) {
            this.mtfRulesLevel = 2;
        }
        if (this.doubleHS) {
            this.mtfRulesLevel = 2;
        }
        if (this.improvedJJ) {
            this.mtfRulesLevel = 2;
        }
        if (this.endo) {
            this.mtfRulesLevel = 2;
        }
        if (!this.engineType.equals("Standard")) {
            this.mtfRulesLevel = 2;
        }
        if (!this.gyro.equals("Standard")) {
            this.mtfRulesLevel = 2;
        }
        if (!this.cockpit.equals("Standard")) {
            this.mtfRulesLevel = 2;
        }
        if (!this.armour.equals("Standard")) {
            this.mtfRulesLevel = 2;
        }
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locCrits[i]; ++j) {
                if (this.locs[i].crits[j] == null || this.locs[i].crits[j].i == null || this.locs[i].crits[j].i.mtfRulesLevel <= this.mtfRulesLevel) continue;
                this.mtfRulesLevel = this.locs[i].crits[j].i.mtfRulesLevel;
            }
        }
        return this.mtfRulesLevel;
    }

    private double calcWeaponMass() {
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locs[i].size; ++j) {
                Mount mount = this.locs[i].crits[j];
                if (mount == null || mount.size <= -1 || mount.i.weight.equals("DoNotCount") || mount.split) continue;
                d += this.getTon.get(mount.i);
            }
        }
        return d;
    }

    public double calcCurrWeight() {
        this.currWeight = 0.0;
        if (this.endo) {
            double d = Math.ceil(this.tonnage * 2.0 / 20.0);
            this.currWeight += (d /= 2.0);
        } else {
            this.currWeight += this.tonnage / 10.0;
        }
        this.currWeight += this.calcArmourTons();
        this.currWeight += this.calcGyroMass();
        this.currWeight += this.calcEngineMass();
        this.currWeight = this.cockpit.equals("Small") ? (this.currWeight += 2.0) : (this.currWeight += 3.0);
        this.currWeight += (double)(this.sinks - 10);
        this.currWeight += this.calcWeaponMass();
        return this.currWeight;
    }

    private void calcInternalStructPts() {
        switch ((int)this.tonnage) {
            case 20: {
                int[] nArray = new int[]{3, 5, 6, 5, 3, 3, 4, 4};
                this.internalStructPts = nArray;
                break;
            }
            case 25: {
                int[] nArray = new int[]{3, 6, 8, 6, 4, 4, 6, 6};
                this.internalStructPts = nArray;
                break;
            }
            case 30: {
                int[] nArray = new int[]{3, 7, 10, 7, 5, 5, 7, 7};
                this.internalStructPts = nArray;
                break;
            }
            case 35: {
                int[] nArray = new int[]{3, 8, 11, 8, 6, 6, 8, 8};
                this.internalStructPts = nArray;
                break;
            }
            case 40: {
                int[] nArray = new int[]{3, 10, 12, 10, 6, 6, 10, 10};
                this.internalStructPts = nArray;
                break;
            }
            case 45: {
                int[] nArray = new int[]{3, 11, 14, 11, 7, 7, 11, 11};
                this.internalStructPts = nArray;
                break;
            }
            case 50: {
                int[] nArray = new int[]{3, 12, 16, 12, 8, 8, 12, 12};
                this.internalStructPts = nArray;
                break;
            }
            case 55: {
                int[] nArray = new int[]{3, 13, 18, 13, 9, 9, 13, 13};
                this.internalStructPts = nArray;
                break;
            }
            case 60: {
                int[] nArray = new int[]{3, 14, 20, 14, 10, 10, 14, 14};
                this.internalStructPts = nArray;
                break;
            }
            case 65: {
                int[] nArray = new int[]{3, 15, 21, 15, 10, 10, 15, 15};
                this.internalStructPts = nArray;
                break;
            }
            case 70: {
                int[] nArray = new int[]{3, 15, 22, 15, 11, 11, 15, 15};
                this.internalStructPts = nArray;
                break;
            }
            case 75: {
                int[] nArray = new int[]{3, 16, 23, 16, 12, 12, 16, 16};
                this.internalStructPts = nArray;
                break;
            }
            case 80: {
                int[] nArray = new int[]{3, 17, 25, 17, 13, 13, 17, 17};
                this.internalStructPts = nArray;
                break;
            }
            case 85: {
                int[] nArray = new int[]{3, 18, 27, 18, 14, 14, 18, 18};
                this.internalStructPts = nArray;
                break;
            }
            case 90: {
                int[] nArray = new int[]{3, 19, 29, 19, 15, 15, 19, 19};
                this.internalStructPts = nArray;
                break;
            }
            case 95: {
                int[] nArray = new int[]{3, 20, 30, 20, 16, 16, 20, 20};
                this.internalStructPts = nArray;
                break;
            }
            case 100: {
                int[] nArray = new int[]{3, 21, 31, 21, 17, 17, 21, 21};
                this.internalStructPts = nArray;
            }
        }
        if (this.isFourLegger) {
            this.internalStructPts[5] = this.internalStructPts[7];
            this.internalStructPts[4] = this.internalStructPts[6];
        }
    }

    private void calcLocCrits() {
        this.locCrits[0] = 6;
        this.locCrits[1] = 12;
        this.locCrits[2] = 12;
        this.locCrits[3] = 12;
        if (this.isFourLegger) {
            this.locCrits[4] = 6;
            this.locCrits[5] = 6;
        } else {
            this.locCrits[4] = 12;
            this.locCrits[5] = 12;
        }
        this.locCrits[6] = 6;
        this.locCrits[7] = 6;
        this.locs[0] = new Loc(this.locCrits[0], this);
        this.locs[1] = new Loc(this.locCrits[1], this);
        this.locs[2] = new Loc(this.locCrits[2], this);
        this.locs[3] = new Loc(this.locCrits[3], this);
        this.locs[4] = new Loc(this.locCrits[4], this);
        this.locs[5] = new Loc(this.locCrits[5], this);
        this.locs[6] = new Loc(this.locCrits[6], this);
        this.locs[7] = new Loc(this.locCrits[7], this);
        this.applyCritsLev0(false);
    }

    public void applyCritsLev0(boolean bl) {
        int n;
        this.locs[0].pushPermanent("Life Support", this.permanentCol);
        this.locs[0].pushPermanent("Sensors", this.permanentCol);
        this.locs[0].pushPermanent("Cockpit", this.permanentCol);
        this.locs[0].pushPermanent("Sensors", this.permanentCol);
        if (this.isFourLegger) {
            this.locs[4].pushPermanent("Hip", this.permanentCol);
            this.locs[4].pushPermanent("Upper Leg Actuator", this.permanentCol);
            this.locs[4].pushPermanent("Lower Leg Actuator", this.permanentCol);
            this.locs[4].pushPermanent("Foot Actuator", this.permanentCol);
            this.locs[5].pushPermanent("Hip", this.permanentCol);
            this.locs[5].pushPermanent("Upper Leg Actuator", this.permanentCol);
            this.locs[5].pushPermanent("Lower Leg Actuator", this.permanentCol);
            this.locs[5].pushPermanent("Foot Actuator", this.permanentCol);
        } else {
            this.locs[4].pushPermanent("Shoulder", this.permanentCol);
            this.locs[4].pushPermanent("Upper Arm Actuator", this.permanentCol);
            this.locs[5].pushPermanent("Shoulder", this.permanentCol);
            this.locs[5].pushPermanent("Upper Arm Actuator", this.permanentCol);
        }
        this.locs[6].pushPermanent("Hip", this.permanentCol);
        this.locs[6].pushPermanent("Upper Leg Actuator", this.permanentCol);
        this.locs[6].pushPermanent("Lower Leg Actuator", this.permanentCol);
        this.locs[6].pushPermanent("Foot Actuator", this.permanentCol);
        this.locs[7].pushPermanent("Hip", this.permanentCol);
        this.locs[7].pushPermanent("Upper Leg Actuator", this.permanentCol);
        this.locs[7].pushPermanent("Lower Leg Actuator", this.permanentCol);
        this.locs[7].pushPermanent("Foot Actuator", this.permanentCol);
        for (n = 0; n < 3; ++n) {
            this.locs[2].pushPermanent("Fusion Engine", this.permanentCol);
        }
        for (n = 0; n < 2; ++n) {
            this.locs[2].pushPermanent("Gyro", this.permanentCol);
        }
        if (!bl) {
            this.applyCritsLev1();
        }
    }

    private void applyCritsLev1() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[8];
        nArray[6] = 4;
        nArray[7] = 4;
        if (this.cockpit.equals("Standard")) {
            if (!this.locs[0].is(4, "Life Support")) {
                this.locs[0].slipPermanent(4, "Life Support", this.semiPermCol);
            }
            nArray[0] = 5;
        } else {
            if (this.locs[0].is(4, "Life Support")) {
                this.locs[0].slide(4);
            }
            nArray[0] = 4;
        }
        if (this.leftArm && !this.isFourLegger) {
            if (!this.locs[4].is(2, "Lower Arm Actuator")) {
                this.locs[4].slipPermanent(2, "Lower Arm Actuator", this.semiPermCol);
            }
            nArray[4] = 3;
        } else {
            if (this.locs[4].is(3, "Hand Actuator")) {
                this.locs[4].slide(3);
            }
            if (this.locs[4].is(2, "Lower Arm Actuator")) {
                this.locs[4].slide(2);
            }
            nArray[4] = 2;
        }
        if (this.leftHand && !this.isFourLegger) {
            if (!this.locs[4].is(2, "Lower Arm Actuator")) {
                this.locs[4].slipPermanent(2, "Lower Arm Actuator", this.semiPermCol);
            }
            if (!this.locs[4].is(3, "Hand Actuator")) {
                this.locs[4].slipPermanent(3, "Hand Actuator", this.semiPermCol);
            }
            nArray[4] = 4;
        } else if (this.locs[4].is(3, "Hand Actuator")) {
            this.locs[4].slide(3);
        }
        if (this.rightArm && !this.isFourLegger) {
            if (!this.locs[5].is(2, "Lower Arm Actuator")) {
                this.locs[5].slipPermanent(2, "Lower Arm Actuator", this.semiPermCol);
            }
            nArray[5] = 3;
        } else {
            if (this.locs[5].is(3, "Hand Actuator")) {
                this.locs[5].slide(3);
            }
            if (this.locs[5].is(2, "Lower Arm Actuator")) {
                this.locs[5].slide(2);
            }
            nArray[5] = 2;
        }
        if (this.rightHand && !this.isFourLegger) {
            if (!this.locs[5].is(2, "Lower Arm Actuator")) {
                this.locs[5].slipPermanent(2, "Lower Arm Actuator", this.semiPermCol);
            }
            if (!this.locs[5].is(3, "Hand Actuator")) {
                this.locs[5].slipPermanent(3, "Hand Actuator", this.semiPermCol);
            }
            nArray[5] = 4;
        } else if (this.locs[5].is(3, "Hand Actuator")) {
            this.locs[5].slide(3);
        }
        if (this.isFourLegger) {
            nArray[4] = 4;
        }
        if (this.isFourLegger) {
            nArray[5] = 4;
        }
        int n4 = 0;
        if (this.engineType.equals("Light")) {
            n4 = 2;
        }
        if (this.engineType.equals("XL") && this.isClan) {
            n4 = 2;
        }
        if (this.engineType.equals("XL") && !this.isClan) {
            n4 = 3;
        }
        if ((n3 = this.locs[1].count("Fusion Engine")) > n4) {
            for (n2 = 0; n2 < n3 - n4; ++n2) {
                this.locs[1].slide(0);
                this.locs[3].slide(0);
            }
        } else if (n3 < n4) {
            for (n2 = 0; n2 < n4 - n3; ++n2) {
                this.locs[1].slipPermanent(0, "Fusion Engine", this.semiPermCol);
                this.locs[3].slipPermanent(0, "Fusion Engine", this.semiPermCol);
            }
        }
        nArray[3] = n4;
        nArray[1] = n4;
        n3 = this.locs[2].count("Gyro");
        n4 = 4;
        if (this.gyro.equals("Compact")) {
            n4 = 2;
        }
        if (this.gyro.equals("XL")) {
            n4 = 6;
        }
        if (n3 > n4) {
            for (n2 = 0; n2 < n3 - n4; ++n2) {
                this.locs[2].slide(5);
            }
        } else if (n3 < n4) {
            for (n2 = 0; n2 < n4 - n3; ++n2) {
                this.locs[2].slipPermanent(5, "Gyro", this.semiPermCol);
            }
        }
        n2 = 3 + n4;
        n3 = this.locs[2].count("Fusion Engine");
        n4 = 6;
        if (this.engineType.equals("Compact")) {
            n4 = 3;
        }
        if (n3 > n4) {
            for (n = 0; n < n3 - n4; ++n) {
                this.locs[2].slide(n2);
            }
        } else if (n3 < n4) {
            for (n = 0; n < n4 - n3; ++n) {
                this.locs[2].slipPermanent(n2, "Fusion Engine", this.semiPermCol);
            }
        }
        nArray[2] = n2 + n4 - 3;
        if (this.locs[1].count("Stealth") > 0 && !this.armour.equals("Stealth")) {
            this.locs[4].slide(nArray[4]);
            this.locs[4].slide(nArray[4]);
            this.locs[5].slide(nArray[5]);
            this.locs[5].slide(nArray[5]);
            this.locs[7].slide(nArray[7]);
            this.locs[7].slide(nArray[7]);
            this.locs[6].slide(nArray[6]);
            this.locs[6].slide(nArray[6]);
            this.locs[1].slide(nArray[1]);
            this.locs[1].slide(nArray[1]);
            this.locs[3].slide(nArray[3]);
            this.locs[3].slide(nArray[3]);
        }
        if (this.locs[1].count("Stealth") == 0 && this.armour.equals("Stealth")) {
            Mount mount = new Mount(new Item("Stealth", 1), 1, this.semiPermCol, true);
            this.locs[4].slip(nArray[4], mount);
            this.locs[4].slip(nArray[4], mount);
            this.locs[5].slip(nArray[5], mount);
            this.locs[5].slip(nArray[5], mount);
            this.locs[7].slip(nArray[7], mount);
            this.locs[7].slip(nArray[7], mount);
            this.locs[6].slip(nArray[6], mount);
            this.locs[6].slip(nArray[6], mount);
            this.locs[1].slip(nArray[1], mount);
            this.locs[1].slip(nArray[1], mount);
            this.locs[3].slip(nArray[3], mount);
            this.locs[3].slip(nArray[3], mount);
        }
        if (this.armour.equals("Stealth")) {
            nArray[1] = nArray[1] + 2;
            nArray[3] = nArray[3] + 2;
            nArray[6] = nArray[6] + 2;
            nArray[7] = nArray[7] + 2;
            nArray[4] = nArray[4] + 2;
            nArray[5] = nArray[5] + 2;
        }
        this.applyCritsLev2(nArray);
    }

    private void applyCritsLev2(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = 1;
        if (this.doubleHS && this.isClan) {
            n4 = 2;
        }
        if (this.doubleHS && !this.isClan) {
            n4 = 3;
        }
        int n5 = Math.max(10 - this.calcFreeHS(), 0);
        int n6 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            n6 += nArray[n3];
        }
        if (this.endo && this.isClan) {
            n6 += 7;
        }
        if (this.endo && !this.isClan) {
            n6 += 14;
        }
        if (this.tsm) {
            n6 += 6;
        }
        if (this.armour.equals("Light Ferro-Fibrous")) {
            n6 += 7;
        }
        if (this.armour.equals("Heavy Ferro-Fibrous")) {
            n6 += 21;
        }
        if (this.armour.equals("Ferro-Fibrous") && this.isClan) {
            n6 += 7;
        }
        if (this.armour.equals("Ferro-Fibrous") && !this.isClan) {
            n6 += 14;
        }
        if ((n6 += n4 * n5) > this.totalCrits() && this.doubleHS) {
            this.msgLabel.setText(this.msgLabel.getText() + "Not enough crits. Heat sink type changed to Standard.  --  ");
            this.doubleHS = false;
            this.applyCritsLev2(nArray);
            return;
        }
        if (n6 > this.totalCrits() && !this.armour.equals("Standard")) {
            this.msgLabel.setText(this.msgLabel.getText() + "Not enough crits. Amour type changed to Standard.  --  ");
            this.armour = "Standard";
            this.applyCritsLev2(nArray);
            return;
        }
        if (n6 > this.totalCrits() && this.tsm) {
            this.msgLabel.setText(this.msgLabel.getText() + "Not enough crits. TSM removed.  --  ");
            this.tsm = false;
            this.applyCritsLev2(nArray);
            return;
        }
        n3 = this.totalCrits() - n6;
        int n7 = Math.max(this.calcFreeHS() - 10, 0) + n3 / n4;
        if (this.sinks > n7 + 10) {
            this.sinks = n7 + 10;
            this.msgLabel.setText(this.msgLabel.getText() + "Not enough crits. Number of heat sinks reduced.  --  ");
            this.applyCritsLev2(nArray);
            return;
        }
        int n8 = 0;
        String string = "ISDoubleHeatSink";
        n8 = !this.doubleHS || this.isClan ? 0 : this.sinks - this.calcFreeHS();
        int n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        string = "Heat Sink";
        n8 = this.doubleHS ? 0 : this.sinks - this.calcFreeHS();
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        string = "CLDoubleHeatSink";
        n8 = !this.doubleHS || !this.isClan ? 0 : this.sinks - this.calcFreeHS();
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        n8 = !this.armour.equals(string = "Light Ferro-Fibrous") ? 0 : 7;
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        n8 = !this.armour.equals(string = "Heavy Ferro-Fibrous") ? 0 : 21;
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        n8 = !this.armour.equals(string = "Ferro-Fibrous") ? 0 : (this.isClan ? 7 : 14);
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        string = "TSM";
        n8 = !this.tsm ? 0 : 6;
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        string = "Endo Steel";
        n8 = !this.endo ? 0 : (this.isClan ? 7 : 14);
        n9 = this.countItem(string);
        if (n9 > n8) {
            this.remove(n9 - n8, string);
        }
        int n10 = 3;
        string = "ISDoubleHeatSink";
        String string2 = "Double Heat Sink";
        if (!this.doubleHS) {
            string = "Heat Sink";
            string2 = "Heat Sink";
            n10 = 1;
        } else if (this.isClan) {
            string = "CLDoubleHeatSink";
            n10 = 2;
        }
        n8 = this.sinks - this.calcFreeHS();
        for (n2 = n9 = this.countItem(string); n2 < n8; ++n2) {
            n = this.mostEmptyCrits();
            int n11 = this.countItem(string);
            this.intToLoc(n).slip(nArray[n], new Mount(new Item(string, n4), n4, this.movableCol, string2));
            int n12 = this.countItem(string);
            if (n11 != n12) continue;
            if (this.calcFreeHS() + n12 > 10) {
                this.sinks = this.calcFreeHS() + n12;
                this.msgLabel.setText(this.msgLabel.getText() + "No space large enough for heat sink. Number of heat sinks reduced.  --  ");
            } else {
                this.doubleHS = false;
                this.msgLabel.setText(this.msgLabel.getText() + "No space large enough for double heat sinks. Heat sink type changed to Standard.  --  ");
            }
            this.applyCritsLev2(nArray);
            return;
        }
        string = "TSM";
        n8 = this.tsm ? 6 : 0;
        for (n2 = n9 = this.countItem(string); n2 < n8; ++n2) {
            n = this.mostEmptyCrits();
            this.intToLoc(n).slip(nArray[n], new Mount(new Item(string), 1, this.movableCol));
        }
        string = "Endo Steel";
        n8 = !this.endo ? 0 : (this.isClan ? 7 : 14);
        for (n2 = n9 = this.countItem(string); n2 < n8; ++n2) {
            n = this.mostEmptyCrits();
            this.intToLoc(n).slip(nArray[n], new Mount(new Item(string), 1, this.movableCol));
        }
        string = this.armour;
        if (string.equals("Standard")) {
            n8 = 0;
        }
        if (string.equals("Stealth")) {
            n8 = 0;
        }
        if (string.equals("Heavy Ferro-Fibrous")) {
            n8 = 21;
        }
        if (string.equals("Light Ferro-Fibrous")) {
            n8 = 7;
        }
        if (string.equals("Ferro-Fibrous") && this.isClan) {
            n8 = 7;
        }
        if (string.equals("Ferro-Fibrous") && !this.isClan) {
            n8 = 14;
        }
        for (n2 = n9 = this.countItem(string); n2 < n8; ++n2) {
            n = this.mostEmptyCrits();
            this.intToLoc(n).slip(nArray[n], new Mount(new Item(string), 1, this.movableCol));
        }
        this.applyCritsLev3();
    }

    private void applyCritsLev3() {
    }

    public void drawCrits() {
        int[] nArray = new int[]{0, 1, 2, 4, 5, 3};
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locCrits[i]; ++j) {
                Mount mount = this.locs[i].crits[j];
                if (mount == null) continue;
                int n = j;
                if (i == 0 && this.cockpit.equals("Standard")) {
                    n = nArray[j];
                }
                this.mdp.writeCrit(i, n, mount.toString(), mount.col);
            }
        }
    }

    public void drawList() {
        Object object;
        BVlist bVlist = new BVlist(this, new boolean[8], this.getHeat, this.getCost, this.getBV, this.getCrit, false);
        int n = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locCrits[i]; ++j) {
                object = this.locs[i].crits[j];
                if (object == null || ((Mount)object).i == null || !((Mount)object).i.showInList || ((Mount)object).split) continue;
                bVlist.add((Mount)object, i);
            }
        }
        for (BVitem bVitem : bVlist.list) {
            object = String.format("%-3s", bVitem.quantity);
            object = (String)object + String.format("%-20s", bVitem.name);
            String string = "";
            switch (bVitem.loc) {
                case 0: {
                    string = "H";
                    break;
                }
                case 1: {
                    string = "LT";
                    break;
                }
                case 3: {
                    string = "RT";
                    break;
                }
                case 2: {
                    string = "CT";
                    break;
                }
                case 6: {
                    if (this.isFourLegger) {
                        string = "LR";
                        break;
                    }
                    string = "LL";
                    break;
                }
                case 7: {
                    if (this.isFourLegger) {
                        string = "RR";
                        break;
                    }
                    string = "RL";
                    break;
                }
                case 5: {
                    if (this.isFourLegger) {
                        string = "RF";
                        break;
                    }
                    string = "RA";
                    break;
                }
                case 4: {
                    string = this.isFourLegger ? "LF" : "LA";
                }
            }
            if (bVitem.rearFacing == 1) {
                string = "r" + string;
            }
            object = (String)object + " " + String.format("%-4s", string);
            object = (String)object + "" + String.format("%-4s", bVitem.listedHeat);
            object = (String)object + " " + String.format("%-4s", bVitem.dam);
            object = (String)object + " " + String.format("%-12s", bVitem.ranges);
            this.mdp.writeEquipment(n, (String)object);
            ++n;
        }
    }

    public void drawRestOfForm() {
        int n;
        for (n = 0; n < 8; ++n) {
            this.mdp.writeStructPoints(n, this.internalStructPts[n]);
        }
        for (n = 0; n < 11; ++n) {
            this.mdp.writeAmrPoints(n, this.locArmour[n]);
        }
        this.mdp.addTextToImg(this.name + "  " + this.variant, this.mdp.type);
        if (this.isOmni) {
            this.mdp.addTextToImg("Omni", this.mdp.omni);
        }
        this.mdp.addTextToImg("" + this.walk, this.mdp.walking);
        this.mdp.addTextToImg("" + this.run, this.mdp.running);
        String[] stringArray = new String[]{"Improved Jump Jet", "Jump Jet", "Clan Improved Jump Jet"};
        this.mdp.addTextToImg("" + this.countItem(stringArray), this.mdp.jumping);
        this.mdp.addTextToImg("" + (int)this.tonnage, this.mdp.tonnage);
        this.mdp.addTextToImg("" + this.calcBV(), this.mdp.bv);
        this.mdp.addTextToImg("" + this.getCostStr(this.calcCost()), this.mdp.cost);
        if (this.tsm) {
            this.mdp.addTextToImg("X", this.mdp.tsm);
        }
        if (this.countItem("ISMASC") > 0) {
            this.mdp.addTextToImg("X", this.mdp.masc);
        } else if (this.countItem("CLMASC") > 0) {
            this.mdp.addTextToImg("X", this.mdp.masc);
        }
        if (this.isClan) {
            this.mdp.addTextToImg("X", this.mdp.clan);
        } else {
            this.mdp.addTextToImg("X", this.mdp.innerSphere);
        }
        int n2 = 1;
        if (this.doubleHS) {
            this.mdp.addTextToImg("X", this.mdp.doubleHS);
            n2 = 2;
        } else {
            this.mdp.addTextToImg("X", this.mdp.singleHS);
        }
        this.mdp.addTextToImg(this.sinks + "  ( " + this.sinks * n2 + " )", this.mdp.heatSinks);
        if (this.gyro.equals("Heavy-Duty")) {
            this.mdp.drawThirdGyroHit();
        }
    }

    public void drawDots() {
        int n;
        int n2;
        int n3 = Math.min(30, this.sinks);
        int[] nArray = this.structMaxes2leg;
        if (this.isFourLegger) {
            nArray = this.structMaxes4leg;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.mdp.fillHeatCircle(29 - n2);
        }
        for (n2 = 1; n2 < 8; ++n2) {
            for (n = 0; n < this.internalStructPts[n2]; ++n) {
                this.mdp.fillStructureCircle(n2, nArray[n2] - 1 - n);
            }
        }
        for (n2 = 0; n2 < this.locArmour[0]; ++n2) {
            this.mdp.fillArmourCircle(0, 8 - n2);
        }
        for (n2 = 1; n2 < 11; ++n2) {
            for (n = 0; n < this.locArmour[n2]; ++n) {
                this.mdp.fillArmourCircle(n2, nArray[n2] * 2 - 1 - n);
            }
        }
    }

    public int calcCost() {
        double d;
        double d2 = 0.0;
        double d3 = 0.0;
        d3 = this.cockpit.equals("Small") ? (d3 += 175000.0) : (d3 += 200000.0);
        d3 += 50000.0;
        d3 += 2000.0 * this.tonnage;
        double d4 = 2000.0;
        if (this.tsm) {
            d4 = 16000.0;
        }
        d3 += d4 * this.tonnage;
        double d5 = 400.0;
        if (this.endo) {
            d5 = 1600.0;
        }
        d3 += d5 * this.tonnage;
        if (this.isFourLegger) {
            d3 += 600.0 * this.tonnage + 320.0 * this.tonnage + 480.0 * this.tonnage;
        } else {
            d3 += 200.0 * this.tonnage;
            d3 += 300.0 * this.tonnage + 160.0 * this.tonnage + 240.0 * this.tonnage;
            if (this.leftArm) {
                d3 += 50.0 * this.tonnage;
            }
            if (this.leftHand) {
                d3 += 80.0 * this.tonnage;
            }
            if (this.rightHand) {
                d3 += 80.0 * this.tonnage;
            }
            if (this.rightArm) {
                d3 += 50.0 * this.tonnage;
            }
        }
        d3 = this.engineType.equals("XL") ? (d3 += (double)(20000 * this.engineRating) * this.tonnage / 75.0) : (this.engineType.equals("Light") ? (d3 += (double)(15000 * this.engineRating) * this.tonnage / 75.0) : (this.engineType.equals("Compact") ? (d3 += (double)(10000 * this.engineRating) * this.tonnage / 75.0) : (d3 += (double)(5000 * this.engineRating) * this.tonnage / 75.0)));
        d3 = this.gyro.equals("Compact") ? (d3 += 400000.0 * this.calcGyroMass()) : (this.gyro.equals("XL") ? (d3 += 750000.0 * this.calcGyroMass()) : (this.gyro.equals("Heavy-Duty") ? (d3 += 500000.0 * this.calcGyroMass()) : (d3 += 300000.0 * this.calcGyroMass())));
        d3 = this.improvedJJ ? (d3 += 500.0 * Math.pow(this.calcJump(), 2.0) * this.tonnage) : (d3 += 200.0 * Math.pow(this.calcJump(), 2.0) * this.tonnage);
        if (this.hasMasc()) {
            d = this.isClan ? Math.ceil(this.tonnage / 25.0) : Math.ceil(this.tonnage / 20.0);
            d3 += 1000.0 * this.calcEngineMass() * d;
        }
        d3 = this.doubleHS ? (d3 += (double)(6000 * this.sinks)) : (d3 += (double)(2000 * (this.sinks - 10)));
        d3 = this.armour.equals("Ferro-Fibrous") ? (d3 += 20000.0 * this.calcArmourTons()) : (this.armour.equals("Light Ferro-Fibrous") ? (d3 += 15000.0 * this.calcArmourTons()) : (this.armour.equals("Heavy Ferro-Fibrous") ? (d3 += 25000.0 * this.calcArmourTons()) : (this.armour.equals("Stealth") ? (d3 += 50000.0 * this.calcArmourTons()) : (d3 += 10000.0 * this.calcArmourTons()))));
        d = 0.0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locCrits[i]; ++j) {
                Mount mount = this.locs[i].crits[j];
                if (mount == null || mount.size == -1 || mount.split || mount.i.isAmmo) continue;
                d += this.getCost.get(mount.i, i);
                if (!(this.getCost.get(mount.i, i) > 0.0)) continue;
                System.out.println("%%%  " + mount.i.id + " " + this.getCost.get(mount.i, i));
            }
        }
        d2 = d3 + d;
        if (this.isOmni) {
            d2 *= 1.25;
        }
        return (int)Math.round(d2 *= 1.0 + this.tonnage / 100.0);
    }

    public int calcBV() {
        String[] stringArray = new String[]{"ISAntiPersonnelPod", "ISBPod", "ISAntiMissileSystem", "ISGuardianECMSuite", "BeagleActiveProbe", "CLAntiPersonnelPod", "CLBPod", "CLAntiMissileSystem", "CLActiveProbe", "CLLightActiveProbe", "CLECMSuite"};
        String[] stringArray2 = new String[]{"CLTargeting Computer", "ISTargeting Computer"};
        boolean bl = this.countItem(stringArray2) > 0;
        boolean[] blArray = new boolean[4];
        for (int i = 1; i <= 3; ++i) {
            blArray[i] = this.locs[i].count("ISCASE") > 0;
        }
        BVlist bVlist = new BVlist(this, blArray, this.getHeat, this.getCost, this.getBV, this.getCrit, bl);
        BVlist bVlist2 = new BVlist(this, blArray, this.getHeat, this.getCost, this.getBV, this.getCrit, bl);
        BVlist bVlist3 = new BVlist(this, blArray, this.getHeat, this.getCost, this.getBV, this.getCrit, bl);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.locCrits[i]; ++j) {
                if (this.locs[i].crits[j] == null || this.locs[i].crits[j].size == -1 || this.locs[i].crits[j].split) continue;
                Mount mount = this.locs[i].crits[j];
                if (this.matches(mount.i.id, stringArray)) {
                    bVlist.add(mount, i);
                    continue;
                }
                if (!mount.i.isAmmo && this.getDam.get(mount.i, 0) > 0.0) {
                    bVlist2.add(mount, i);
                    continue;
                }
                if (mount.i.isAmmo) continue;
                bVlist3.add(mount, i);
            }
        }
        bVlist3.trimExcessiveAmmo();
        bVlist2.trimExcessiveAmmo();
        bVlist2.swapFireArcs();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < 11; ++i) {
            d2 += (double)this.locArmour[i];
        }
        double d3 = 1.0;
        double d4 = d2 * 2.5 * d3;
        d += d4;
        double d5 = 0.0;
        for (int i = 0; i < 8; ++i) {
            d5 += (double)this.internalStructPts[i];
        }
        double d6 = 1.0;
        double d7 = 1.0;
        if (this.engineType.equals("Light")) {
            d7 = 0.75;
        }
        if (this.engineType.equals("XL") && this.isClan) {
            d7 = 0.75;
        }
        if (this.engineType.equals("XL") && !this.isClan) {
            d7 = 0.5;
        }
        double d8 = d5 * 1.5 * d6 * d7;
        d += d8;
        double d9 = 0.5;
        if (this.gyro.equals("Heavy-Duty")) {
            d9 = 1.0;
        }
        double d10 = this.tonnage * d9;
        d += d10;
        d += bVlist.getTotalModifiedBV();
        double d11 = this.calcExplosivesPenalty();
        if ((d -= d11) < 1.0) {
            d = 1.0;
        }
        double d12 = this.calcJump();
        double d13 = this.run;
        if (this.tsm) {
            d13 = Math.ceil(1.5 * (double)(this.walk + 1));
        }
        if (this.hasMasc()) {
            d13 = this.walk * 2;
        }
        double d14 = this.moveToHitMod(d13);
        if (d12 > 0.0) {
            d14 = Math.max(this.moveToHitMod(d12) + 1.0, d14);
        }
        if (this.armour.equals("Stealth")) {
            d14 += 2.0;
        }
        double d15 = 1.0 + d14 * 0.1;
        d *= d15;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 1.0;
        if (this.doubleHS) {
            d18 = 2.0;
        }
        double d19 = 2.0;
        if (d12 > 2.0) {
            d19 = d12;
        }
        double d20 = 6.0 + (double)this.sinks * d18 - d19;
        d16 += bVlist2.getTotalModifiedBV(d20);
        d16 += bVlist3.getTotalModifiedBV();
        double d21 = 1.0;
        if (this.tsm) {
            d21 = 1.5;
        }
        d16 += this.tonnage * d21;
        int n = (int)Math.ceil(d12 / 2.0);
        int n2 = this.run + n;
        if (this.tsm) {
            n2 += 2;
        }
        if (this.hasMasc()) {
            ++n2;
        }
        double[] dArray = new double[]{0.44, 0.54, 0.65, 0.77, 0.88, 1.0, 1.12, 1.24, 1.37, 1.5, 1.63, 1.76, 1.89, 2.02, 2.16, 2.3, 2.44, 2.58, 2.72, 2.86, 3.0, 3.15, 3.29, 3.44, 3.59, 3.75};
        double d22 = dArray[n2];
        d16 *= d22;
        double[][] dArrayArray = new double[][]{{3.68, 3.36, 3.05, 2.73, 2.42, 2.1, 2.0, 1.89, 1.79}, {3.33, 3.04, 2.76, 2.47, 2.19, 1.9, 1.81, 1.71, 1.62}, {2.8, 2.56, 2.32, 2.08, 1.84, 1.6, 1.52, 1.44, 1.36}, {2.28, 2.08, 1.89, 1.69, 1.5, 1.3, 1.24, 1.17, 1.11}, {1.75, 1.6, 1.45, 1.3, 1.15, 1.0, 0.95, 0.9, 0.85}, {1.58, 1.44, 1.31, 1.17, 1.04, 0.9, 0.86, 0.81, 0.77}, {1.4, 1.28, 1.16, 1.04, 0.92, 0.8, 0.76, 0.72, 0.68}, {1.23, 1.12, 1.02, 0.91, 0.81, 0.7, 0.67, 0.63, 0.6}, {1.05, 0.96, 0.87, 0.78, 0.69, 0.6, 0.57, 0.54, 0.51}};
        int n3 = 4;
        int n4 = 5;
        if (this.cockpit.equals("Small")) {
            ++n4;
        }
        double d23 = dArrayArray[n3][n4];
        int n5 = (int)Math.round((d16 + d) * d23);
        return n5;
    }

    private double moveToHitMod(double d) {
        if (d >= 25.0) {
            return 6.0;
        }
        if (d >= 18.0) {
            return 5.0;
        }
        if (d >= 10.0) {
            return 4.0;
        }
        if (d >= 7.0) {
            return 3.0;
        }
        if (d >= 5.0) {
            return 2.0;
        }
        if (d >= 3.0) {
            return 1.0;
        }
        return 0.0;
    }

    private boolean matches(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private double calcExplosivesPenalty() {
        double d = 0.0;
        if (this.isClan) {
            d += (double)(15 * this.countAmmo(0));
            d += (double)(15 * this.countAmmo(2));
            d += (double)(15 * this.countAmmo(6));
            d += (double)(15 * this.countAmmo(7));
            d += (double)(1 * this.countGaussGun(0));
            d += (double)(1 * this.countGaussGun(2));
            d += (double)(1 * this.countGaussGun(6));
            d += (double)(1 * this.countGaussGun(7));
        } else if (this.engineType.equals("XL")) {
            d += (double)(15 * this.countAmmo(0));
            d += (double)(15 * this.countAmmo(2));
            d += (double)(15 * this.countAmmo(1));
            d += (double)(15 * this.countAmmo(3));
            d += (double)(15 * this.countAmmo(5));
            d += (double)(15 * this.countAmmo(4));
            d += (double)(15 * this.countAmmo(6));
            d += (double)(15 * this.countAmmo(7));
            d += (double)(1 * this.countGaussGun(0));
            d += (double)(1 * this.countGaussGun(2));
            d += (double)(1 * this.countGaussGun(1));
            d += (double)(1 * this.countGaussGun(3));
            d += (double)(1 * this.countGaussGun(4));
            d += (double)(1 * this.countGaussGun(5));
            d += (double)(1 * this.countGaussGun(6));
            d += (double)(1 * this.countGaussGun(7));
        } else {
            d += (double)(15 * this.countAmmo(0));
            d += (double)(15 * this.countAmmo(2));
            d += (double)(15 * this.countAmmo(6));
            d += (double)(15 * this.countAmmo(7));
            d += (double)(15 * this.countAmmo(1) * this.noCaseHere(1));
            d += (double)(15 * this.countAmmo(3) * this.noCaseHere(3));
            d += (double)(15 * this.countAmmo(5) * this.noCaseHere(3));
            d += (double)(15 * this.countAmmo(4) * this.noCaseHere(1));
            d += (double)(1 * this.countGaussGun(0));
            d += (double)(1 * this.countGaussGun(2));
            d += (double)(1 * this.countGaussGun(6));
            d += (double)(1 * this.countGaussGun(7));
            d += (double)(1 * this.countGaussGun(1) * this.noCaseHere(1));
            d += (double)(1 * this.countGaussGun(3) * this.noCaseHere(3));
            d += (double)(1 * this.countGaussGun(4) * this.noCaseHere(1));
            d += (double)(1 * this.countGaussGun(5) * this.noCaseHere(3));
        }
        int n = 0;
        if (this.locs[2].count("ISHeavyGaussRifle", true) > 0) {
            d += 11.0;
            ++n;
        }
        for (int i = 0; i < this.locCrits[1]; ++i) {
            if (this.locs[1].crits[i] != null && this.locs[1].crits[i].size != -1 && this.locs[1].crits[i].i.id.equals("ISHeavyGaussRifle") && this.locs[1].crits[i].partner == null) {
                d += (double)(11 * this.noCaseHere(1));
            }
            if (this.locs[3].crits[i] == null || this.locs[3].crits[i].size == -1 || !this.locs[3].crits[i].i.id.equals("ISHeavyGaussRifle") || this.locs[3].crits[i].partner != null) continue;
            d += (double)(11 * this.noCaseHere(3));
        }
        return d;
    }

    public String getCostStr(int n) {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###");
        return decimalFormat.format(n);
    }

    private int countAmmo(int n) {
        int n2 = 0;
        for (int i = 0; i < this.locCrits[n]; ++i) {
            if (this.locs[n].crits[i] == null || this.locs[n].crits[i].i == null || !this.locs[n].crits[i].i.isAmmo || this.locs[n].crits[i].i.id.equals("Clan Gauss Ammo") || this.locs[n].crits[i].i.id.equals("CLAPGaussRifle Ammo") || this.locs[n].crits[i].i.id.equals("HAG/20 Ammo") || this.locs[n].crits[i].i.id.equals("HAG/30 Ammo") || this.locs[n].crits[i].i.id.equals("HAG/40 Ammo") || this.locs[n].crits[i].i.id.equals("IS Light Gauss Ammo") || this.locs[n].crits[i].i.id.equals("IS Gauss Ammo") || this.locs[n].crits[i].i.id.equals("ISHeavyGauss Ammo")) continue;
            n2 += this.locs[n].crits[i].size;
        }
        return n2;
    }

    private int countGaussGun(int n) {
        int n2 = 0;
        for (int i = 0; i < this.locCrits[n]; ++i) {
            if (this.locs[n].crits[i] == null || this.locs[n].crits[i].i == null || !this.locs[n].crits[i].i.id.equals("ISLightGaussRifle") && !this.locs[n].crits[i].i.id.equals("ISGaussRifle") && !this.locs[n].crits[i].i.id.equals("CLAPGaussRifle") && !this.locs[n].crits[i].i.id.equals("CLGaussRifle") && !this.locs[n].crits[i].i.id.equals("CLHAG20") && !this.locs[n].crits[i].i.id.equals("CLHAG30") && !this.locs[n].crits[i].i.id.equals("CLHAG40")) continue;
            n2 += this.locs[n].crits[i].size;
        }
        return n2;
    }

    private int noCaseHere(int n) {
        if (this.locs[n].count("ISCASE") > 0) {
            return 0;
        }
        return 1;
    }

    private boolean hasMasc() {
        String[] stringArray = new String[]{"ISMASC", "CLMASC"};
        return this.countItem(stringArray) > 0;
    }

    public boolean calcTargComp() {
        String[] stringArray = new String[]{"ISTargeting Computer", "CLTargeting Computer"};
        this.targComp = this.countItem(stringArray) > 0;
        return this.targComp;
    }

    public void drawRadars() {
        int n;
        int n2;
        this.calcTargComp();
        double[][] dArray = new double[4][25];
        int[][] nArray = new int[4][25];
        int n3 = Math.max(2, this.calcJump());
        if (this.armour.equals("Stealth")) {
            n3 = 12;
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 1; n <= 24; ++n) {
                nArray[n2][n] = n3;
                dArray[n2][n] = 0.0;
            }
        }
        for (n2 = 0; n2 < 8; ++n2) {
            for (n = 0; n < this.locCrits[n2]; ++n) {
                Mount mount = this.locs[n2].crits[n];
                if (mount == null || mount.i == null || !mount.i.isWeapon || mount.split) continue;
                int[] nArray2 = this.getRange.get(mount.i);
                if (nArray2[3] > 24) {
                    nArray2[3] = 24;
                }
                block14: for (int i = nArray2[0] + 1; i <= nArray2[3]; ++i) {
                    double d = this.getHeat.get(mount.i);
                    if (mount.rearFacing) {
                        int[] nArray3 = nArray[3];
                        int n4 = i;
                        nArray3[n4] = (int)((double)nArray3[n4] + d);
                    } else {
                        switch (n2) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 6: 
                            case 7: {
                                int[] nArray4 = nArray[0];
                                int n5 = i;
                                nArray4[n5] = (int)((double)nArray4[n5] + d);
                                break;
                            }
                            case 4: {
                                int[] nArray5 = nArray[0];
                                int n6 = i;
                                nArray5[n6] = (int)((double)nArray5[n6] + d);
                                int[] nArray6 = nArray[1];
                                int n7 = i;
                                nArray6[n7] = (int)((double)nArray6[n7] + d);
                                break;
                            }
                            case 5: {
                                int[] nArray7 = nArray[0];
                                int n8 = i;
                                nArray7[n8] = (int)((double)nArray7[n8] + d);
                                int[] nArray8 = nArray[2];
                                int n9 = i;
                                nArray8[n9] = (int)((double)nArray8[n9] + d);
                            }
                        }
                    }
                    double d2 = this.getDam.get(mount.i, i);
                    if (mount.rearFacing) {
                        double[] dArray2 = dArray[3];
                        int n10 = i;
                        dArray2[n10] = dArray2[n10] + d2;
                        continue;
                    }
                    switch (n2) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: {
                            double[] dArray3 = dArray[0];
                            int n11 = i;
                            dArray3[n11] = dArray3[n11] + d2;
                            continue block14;
                        }
                        case 4: {
                            double[] dArray4 = dArray[0];
                            int n12 = i;
                            dArray4[n12] = dArray4[n12] + d2;
                            double[] dArray5 = dArray[1];
                            int n13 = i;
                            dArray5[n13] = dArray5[n13] + d2;
                            continue block14;
                        }
                        case 5: {
                            double[] dArray6 = dArray[0];
                            int n14 = i;
                            dArray6[n14] = dArray6[n14] + d2;
                            double[] dArray7 = dArray[2];
                            int n15 = i;
                            dArray7[n15] = dArray7[n15] + d2;
                        }
                    }
                }
            }
        }
        n2 = 1;
        if (this.isFourLegger) {
            n2 = 3;
        }
        for (n = 0; n < 3; n += n2) {
            for (int i = 1; i <= 24; ++i) {
                if (dArray[n][i] > 0.0 && dArray[n][i] < 1.0) {
                    dArray[n][i] = 1.0;
                }
                dArray[n][i] = Math.round(dArray[n][i]);
                if (dArray[n][i] > 50.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 30.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 20.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 15.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 10.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 5.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                } else if (dArray[n][i] > 0.0) {
                    this.mdp.floodRadar(this.mdp.maxDamage, n, this.calcDamCol(dArray[n][i]), i);
                }
                int n16 = 1;
                if (this.doubleHS) {
                    n16 = 2;
                }
                if (nArray[n][i] <= n3) continue;
                double d = (double)(this.sinks * n16) / (double)nArray[n][i];
                this.mdp.floodRadar(this.mdp.heatCapacity, n, this.calcHeatCol(d), i);
            }
        }
    }

    private Color calcDamCol(double d) {
        int n = (int)d;
        if (n > 99) {
            return this.damColMax;
        }
        if (n <= 0) {
            return Color.white;
        }
        if (n < 5) {
            double d2 = this.percentFromLeft(1, 5, n);
            double d3 = 1.0 - d2;
            int n2 = (int)((double)this.damColOne.getRed() * d3 + (double)this.damColVeryLow.getRed() * d2);
            int n3 = (int)((double)this.damColOne.getBlue() * d3 + (double)this.damColVeryLow.getBlue() * d2);
            int n4 = (int)((double)this.damColOne.getGreen() * d3 + (double)this.damColVeryLow.getGreen() * d2);
            return new Color(n2, n4, n3);
        }
        if (n < 10) {
            double d4 = this.percentFromLeft(5, 10, n);
            double d5 = 1.0 - d4;
            int n5 = (int)((double)this.damColVeryLow.getRed() * d5 + (double)this.damColLow.getRed() * d4);
            int n6 = (int)((double)this.damColVeryLow.getBlue() * d5 + (double)this.damColLow.getBlue() * d4);
            int n7 = (int)((double)this.damColVeryLow.getGreen() * d5 + (double)this.damColLow.getGreen() * d4);
            return new Color(n5, n7, n6);
        }
        if (n < 20) {
            double d6 = this.percentFromLeft(10, 20, n);
            double d7 = 1.0 - d6;
            int n8 = (int)((double)this.damColLow.getRed() * d7 + (double)this.damColMed.getRed() * d6);
            int n9 = (int)((double)this.damColLow.getBlue() * d7 + (double)this.damColMed.getBlue() * d6);
            int n10 = (int)((double)this.damColLow.getGreen() * d7 + (double)this.damColMed.getGreen() * d6);
            return new Color(n8, n10, n9);
        }
        if (n < 50) {
            double d8 = this.percentFromLeft(20, 50, n);
            double d9 = 1.0 - d8;
            int n11 = (int)((double)this.damColMed.getRed() * d9 + (double)this.damColHigh.getRed() * d8);
            int n12 = (int)((double)this.damColMed.getBlue() * d9 + (double)this.damColHigh.getBlue() * d8);
            int n13 = (int)((double)this.damColMed.getGreen() * d9 + (double)this.damColHigh.getGreen() * d8);
            return new Color(n11, n13, n12);
        }
        if (n < 100) {
            double d10 = this.percentFromLeft(50, 100, n);
            double d11 = 1.0 - d10;
            int n14 = (int)((double)this.damColHigh.getRed() * d11 + (double)this.damColMax.getRed() * d10);
            int n15 = (int)((double)this.damColHigh.getBlue() * d11 + (double)this.damColMax.getBlue() * d10);
            int n16 = (int)((double)this.damColHigh.getGreen() * d11 + (double)this.damColMax.getGreen() * d10);
            return new Color(n14, n16, n15);
        }
        return Color.magenta;
    }

    private Color calcHeatCol(double d) {
        int n = (int)(100.0 * d);
        if (n > 499) {
            return this.heatColMax;
        }
        if (n <= 0) {
            return Color.white;
        }
        if (n < 50) {
            double d2 = this.percentFromLeft(1, 50, n);
            double d3 = 1.0 - d2;
            int n2 = (int)((double)this.heatColOne.getRed() * d3 + (double)this.heatColVeryLow.getRed() * d2);
            int n3 = (int)((double)this.heatColOne.getBlue() * d3 + (double)this.heatColVeryLow.getBlue() * d2);
            int n4 = (int)((double)this.heatColOne.getGreen() * d3 + (double)this.heatColVeryLow.getGreen() * d2);
            return new Color(n2, n4, n3);
        }
        if (n < 75) {
            double d4 = this.percentFromLeft(50, 75, n);
            double d5 = 1.0 - d4;
            int n5 = (int)((double)this.heatColVeryLow.getRed() * d5 + (double)this.heatColLow.getRed() * d4);
            int n6 = (int)((double)this.heatColVeryLow.getBlue() * d5 + (double)this.heatColLow.getBlue() * d4);
            int n7 = (int)((double)this.heatColVeryLow.getGreen() * d5 + (double)this.heatColLow.getGreen() * d4);
            return new Color(n5, n7, n6);
        }
        if (n < 100) {
            double d6 = this.percentFromLeft(75, 100, n);
            double d7 = 1.0 - d6;
            int n8 = (int)((double)this.heatColLow.getRed() * d7 + (double)this.heatColMed.getRed() * d6);
            int n9 = (int)((double)this.heatColLow.getBlue() * d7 + (double)this.heatColMed.getBlue() * d6);
            int n10 = (int)((double)this.heatColLow.getGreen() * d7 + (double)this.heatColMed.getGreen() * d6);
            return new Color(n8, n10, n9);
        }
        if (n < 110) {
            double d8 = this.percentFromLeft(100, 110, n);
            double d9 = 1.0 - d8;
            int n11 = (int)((double)this.heatColMed.getRed() * d9 + (double)this.heatColHigh.getRed() * d8);
            int n12 = (int)((double)this.heatColMed.getBlue() * d9 + (double)this.heatColHigh.getBlue() * d8);
            int n13 = (int)((double)this.heatColMed.getGreen() * d9 + (double)this.heatColHigh.getGreen() * d8);
            return new Color(n11, n13, n12);
        }
        if (n < 500) {
            double d10 = this.percentFromLeft(110, 500, n);
            double d11 = 1.0 - d10;
            int n14 = (int)((double)this.heatColHigh.getRed() * d11 + (double)this.heatColMax.getRed() * d10);
            int n15 = (int)((double)this.heatColHigh.getBlue() * d11 + (double)this.heatColMax.getBlue() * d10);
            int n16 = (int)((double)this.heatColHigh.getGreen() * d11 + (double)this.heatColMax.getGreen() * d10);
            return new Color(n14, n16, n15);
        }
        return Color.magenta;
    }

    private double percentFromLeft(int n, int n2, int n3) {
        double d = n2 - n;
        double d2 = n3 - n;
        return d2 / d;
    }

    private int remove(int n, String string) {
        int n2 = 0;
        while (n2 < n && (n2 += this.locs[4].slide(this.locs[4].getLast(string))) < n && (n2 += this.locs[5].slide(this.locs[5].getLast(string))) < n && (n2 += this.locs[1].slide(this.locs[1].getLast(string))) < n && (n2 += this.locs[3].slide(this.locs[3].getLast(string))) < n && (n2 += this.locs[2].slide(this.locs[2].getLast(string))) < n && (n2 += this.locs[6].slide(this.locs[6].getLast(string))) < n && (n2 += this.locs[7].slide(this.locs[7].getLast(string))) < n) {
            n2 += this.locs[0].slide(this.locs[0].getLast(string));
            if (this.countItem(string) != 0) continue;
            break;
        }
        return n2;
    }

    public int countItem(String string) {
        String[] stringArray = new String[]{string};
        return this.countItem(stringArray);
    }

    public int countItem(String[] stringArray) {
        int n = 0;
        n += this.locs[0].count(stringArray);
        n += this.locs[1].count(stringArray);
        n += this.locs[2].count(stringArray);
        n += this.locs[3].count(stringArray);
        n += this.locs[4].count(stringArray);
        n += this.locs[5].count(stringArray);
        n += this.locs[6].count(stringArray);
        return n += this.locs[7].count(stringArray);
    }

    public void refreshTargetingComputer() {
        int n;
        int n2;
        String string = "ISTargeting Computer";
        if (this.isClan) {
            string = "CLTargeting Computer";
        }
        int[] nArray = new int[8];
        int n3 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            nArray[n2] = this.locs[n2].count(string);
            n3 += nArray[n2];
            for (n = 0; n < nArray[n2]; ++n) {
                this.locs[n2].slide(this.locs[n2].getLast(string));
            }
        }
        if (n3 == 0) {
            return;
        }
        this.currWeight = this.calcCurrWeight();
        n2 = (int)this.getTon.get(new Item(string));
        if (n2 > 12) {
            this.msgLabel.setText("Targeting computer too large to fit in single location.  --  " + this.msgLabel.getText());
            return;
        }
        if (n2 > 0) {
            for (n = 0; n < 8; ++n) {
                if (nArray[n] <= 0) continue;
                for (int i = 0; i < nArray[n]; ++i) {
                    if (this.currWeight + (double)n2 > this.tonnage) {
                        this.msgLabel.setText("Targeting computer(s) grown too heavy - quantity reduced.  --  " + this.msgLabel.getText());
                        return;
                    }
                    int n4 = this.locs[n].critsLeft();
                    if (n4 >= n2) {
                        Item item = new Item(string);
                        item.crits = "" + n2;
                        item.weight = "" + n2;
                        item.name = "Targeting Computer";
                        this.locs[n].push(new Mount(item, n2, this.nonWeapCol));
                        this.currWeight += (double)n2;
                        continue;
                    }
                    this.msgLabel.setText(this.msgLabel.getText() + "Targeting computer(s) grown too large - quantity reduced.  --  ");
                }
            }
        }
    }

    public int calcFreeHS() {
        return this.calcEngineRating() / 25;
    }

    private int calcEngineRating() {
        return this.walk * (int)this.tonnage;
    }

    private double calcEngineMass() {
        double[] dArray = new double[]{1.0, 1.0, 1.0, 1.0, 1.5, 1.5, 1.5, 1.5, 2.5, 2.5, 2.5, 3.0, 3.0, 3.0, 4.0, 4.0, 4.5, 4.5, 4.5, 5.5, 5.5, 6.0, 6.0, 6.0, 7.0, 7.0, 7.5, 7.5, 8.5, 8.5, 9.0, 9.0, 9.0, 10.5, 10.5, 11.5, 11.5, 12.0, 13.0, 13.0, 13.5, 14.5, 15.0, 15.0, 16.0, 16.5, 17.5, 18.0, 19.0, 19.5, 20.5, 21.0, 22.0, 23.5, 24.0, 25.0, 26.5, 27.0, 28.5, 29.5, 31.0, 32.5, 34.0, 35.5, 37.0, 38.5, 40.5, 43.0, 44.5, 47.5, 49.5, 52.0, 55.0, 58.0, 61.5, 65.5, 69.0, 73.5, 79.0};
        double[] dArray2 = new double[]{0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, 1.5, 1.5, 1.5, 2.0, 2.0, 2.0, 2.5, 2.5, 3.0, 3.0, 3.0, 3.5, 3.5, 4.0, 4.0, 4.0, 4.5, 4.5, 5.0, 5.0, 5.5, 5.5, 6.0, 6.0, 6.0, 7.0, 7.0, 7.5, 7.5, 8.0, 8.5, 8.5, 9.0, 9.5, 10.0, 10.0, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 14.0, 14.5, 15.5, 16.0, 16.5, 17.5, 18.0, 19.0, 19.5, 20.5, 21.5, 22.5, 23.5, 24.5, 25.5, 27.0, 28.5, 29.5, 31.5, 33.0, 34.5, 36.5, 38.5, 41.0, 43.5, 46.0, 49.0, 52.5};
        double[] dArray3 = new double[]{0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.5, 1.5, 1.5, 1.5, 1.5, 2.0, 2.0, 2.0, 2.0, 2.0, 2.5, 2.5, 2.5, 2.5, 3.0, 3.0, 3.0, 3.0, 3.0, 3.5, 3.5, 4.0, 4.0, 4.0, 4.5, 4.5, 4.5, 5.0, 5.0, 5.0, 5.5, 5.5, 6.0, 6.0, 6.5, 6.5, 7.0, 7.0, 7.5, 8.0, 8.0, 8.5, 9.0, 9.0, 9.5, 10.0, 10.5, 11.0, 11.5, 12.0, 12.5, 13.0, 13.5, 14.5, 15.0, 16.0, 16.5, 17.5, 18.5, 19.5, 20.5, 22.0, 23.0, 24.5, 26.5};
        double[] dArray4 = new double[]{0.5, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0, 1.0, 1.5, 1.5, 1.5, 1.5, 1.5, 1.5, 2.0, 2.0, 2.5, 2.5, 2.5, 3.0, 3.0, 3.0, 3.0, 3.0, 3.5, 3.5, 4.0, 4.0, 4.5, 4.5, 4.5, 4.5, 4.5, 5.5, 5.5, 6.0, 6.0, 6.0, 6.5, 6.5, 7.0, 7.5, 7.5, 7.5, 8.0, 8.5, 9.0, 9.0, 9.5, 10.0, 10.5, 10.5, 11.0, 12.0, 12.0, 12.5, 13.5, 13.5, 14.5, 15.0, 15.5, 16.5, 17.0, 18.0, 18.5, 19.5, 20.5, 21.5, 22.5, 24.0, 25.0, 26.0, 27.5, 29.0, 31.0, 33.0, 34.5, 37.0, 39.5};
        double[] dArray5 = dArray2;
        if (this.engineType.equals("XL")) {
            dArray5 = dArray3;
        }
        if (this.engineType.equals("Light")) {
            dArray5 = dArray4;
        }
        if (this.engineType.equals("Compact")) {
            dArray5 = dArray;
        }
        this.engineMass = dArray5[this.calcEngineRating() / 5 - 2];
        return this.engineMass;
    }

    private double calcGyroMass() {
        this.gyroMass = Math.ceil((double)this.calcEngineRating() / 100.0);
        double d = 1.0;
        if (this.gyro.equals("Heavy-Duty")) {
            d = 2.0;
        }
        if (this.gyro.equals("XL")) {
            d = 0.5;
        }
        if (this.gyro.equals("Compact")) {
            d = 1.5;
        }
        this.gyroMass *= d;
        return this.gyroMass;
    }

    public int calcMaxArmour() {
        this.maxArmour = 0;
        for (int i = 0; i < this.internalStructPts.length; ++i) {
            this.maxArmour += this.internalStructPts[i];
        }
        this.maxArmour *= 2;
        this.maxArmour += 3;
        return this.maxArmour;
    }

    private double calcMaxArmTons() {
        this.maxArmTons = 0.0;
        double d = 1.0;
        if (this.armour.equals("Light Ferro-Fibrous")) {
            d = 1.06;
        }
        if (this.armour.equals("Heavy Ferro-Fibrous")) {
            d = 1.24;
        }
        if (this.armour.equals("Ferro-Fibrous") && this.isClan) {
            d = 1.2;
        }
        if (this.armour.equals("Ferro-Fibrous") && !this.isClan) {
            d = 1.12;
        }
        double d2 = 16.0 * d;
        this.maxArmTons = (double)this.calcMaxArmour() / d2;
        this.maxArmTons = 0.5 * Math.ceil(this.maxArmTons / 0.5);
        return this.maxArmTons;
    }

    public int calcArmourPts() {
        this.armourPts = 0;
        for (int i = 0; i < this.locArmour.length; ++i) {
            this.armourPts += this.locArmour[i];
        }
        return this.armourPts;
    }

    public double calcArmourTons() {
        this.armourTons = 0.0;
        double d = 1.0;
        if (this.armour.equals("Light Ferro-Fibrous")) {
            d = 1.06;
        }
        if (this.armour.equals("Heavy Ferro-Fibrous")) {
            d = 1.24;
        }
        if (this.armour.equals("Ferro-Fibrous") && this.isClan) {
            d = 1.2;
        }
        if (this.armour.equals("Ferro-Fibrous") && !this.isClan) {
            d = 1.12;
        }
        double d2 = 16.0 * d;
        this.armourTons = (double)this.calcArmourPts() / d2;
        this.armourTons = 0.5 * Math.ceil(this.armourTons / 0.5);
        return this.armourTons;
    }

    private void calcLocMaxArmour() {
        for (int i = 0; i < this.internalStructPts.length; ++i) {
            this.locMaxArmour[i] = this.internalStructPts[i] * 2;
        }
        this.locMaxArmour[0] = 9;
        this.locMaxArmour[9] = this.locMaxArmour[2];
        this.locMaxArmour[10] = this.locMaxArmour[3];
        this.locMaxArmour[8] = this.locMaxArmour[1];
    }

    public int calcJump() {
        String[] stringArray = new String[]{"Clan Improved Jump Jet", "Jump Jet", "Improved Jump Jet"};
        this.jump = this.countItem(stringArray);
        return this.jump;
    }

    private Loc intToLoc(int n) {
        switch (n) {
            case 0: {
                return this.locs[0];
            }
            case 1: {
                return this.locs[1];
            }
            case 2: {
                return this.locs[2];
            }
            case 3: {
                return this.locs[3];
            }
            case 4: {
                return this.locs[4];
            }
            case 5: {
                return this.locs[5];
            }
            case 6: {
                return this.locs[6];
            }
            case 7: {
                return this.locs[7];
            }
        }
        return null;
    }

    private int mostEmptyCrits() {
        int n = 0;
        if (this.locs[6].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 6;
        }
        if (this.locs[7].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 7;
        }
        if (this.locs[2].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 2;
        }
        if (this.locs[5].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 5;
        }
        if (this.locs[4].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 4;
        }
        if (this.locs[3].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 3;
        }
        if (this.locs[1].critsLeft() >= this.intToLoc(n).critsLeft()) {
            n = 1;
        }
        return n;
    }

    private int leastEmptyCrits(int n) {
        int n2 = 0;
        if (this.locs[6].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[6].critsLeft() >= n) {
            n2 = 6;
        }
        if (this.locs[7].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[7].critsLeft() >= n) {
            n2 = 7;
        }
        if (this.locs[2].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[2].critsLeft() >= n) {
            n2 = 2;
        }
        if (this.locs[5].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[5].critsLeft() >= n) {
            n2 = 5;
        }
        if (this.locs[4].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[4].critsLeft() >= n) {
            n2 = 4;
        }
        if (this.locs[3].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[3].critsLeft() >= n) {
            n2 = 3;
        }
        if (this.locs[1].critsLeft() < this.intToLoc(n2).critsLeft() && this.locs[1].critsLeft() >= n) {
            n2 = 1;
        }
        return n2;
    }

    public int totalEmptyCrits() {
        int n = this.locs[0].critsLeft();
        n += this.locs[1].critsLeft();
        n += this.locs[2].critsLeft();
        n += this.locs[3].critsLeft();
        n += this.locs[4].critsLeft();
        n += this.locs[5].critsLeft();
        n += this.locs[6].critsLeft();
        return n += this.locs[7].critsLeft();
    }

    public int totalCrits() {
        if (this.isFourLegger) {
            return 66;
        }
        return 78;
    }

    public void update() {
        this.applyCritsLev1();
        this.engineRating = this.calcEngineRating();
        this.engineMass = this.calcEngineMass();
        this.gyroMass = this.calcGyroMass();
        this.maxArmTons = this.calcMaxArmTons();
        this.calcArmourPts();
        this.calcArmourTons();
        this.currWeight = this.calcCurrWeight();
    }

    public void clear() {
        this.endo = false;
        this.walk = 1;
        this.run = 2;
        this.jump = 0;
        this.engineType = "Standard";
        this.gyro = "Standard";
        this.improvedJJ = false;
        this.cockpit = "Standard";
        this.tsm = false;
        this.doubleHS = false;
        this.leftArm = true;
        this.leftHand = true;
        this.rightArm = true;
        this.rightHand = true;
        this.targComp = false;
        this.sinks = 10;
        this.armour = "Standard";
        this.armourTons = 0.0;
        this.armourPts = 0;
        for (int i = 0; i < 11; ++i) {
            this.locArmour[i] = 0;
        }
        this.calcInternalStructPts();
        this.maxArmour = this.calcMaxArmour();
        this.calcLocCrits();
        this.engineRating = this.calcEngineRating();
        this.engineMass = this.calcEngineMass();
        this.gyroMass = this.calcGyroMass();
        this.maxArmTons = this.calcMaxArmTons();
        this.calcLocMaxArmour();
        this.currWeight = this.calcCurrWeight();
    }

    public String toString() {
        int n;
        String string = "\n\n$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n";
        string = string + this.name + "-" + this.variant;
        string = string + " clan:" + this.isClan;
        string = string + " 4leg:" + this.isFourLegger;
        string = string + " omni:" + this.isOmni;
        string = string + " tons:" + this.tonnage;
        string = string + " era:" + this.era;
        string = string + "\n\nintStructPts:";
        for (n = 0; n < this.internalStructPts.length; ++n) {
            string = string + " " + this.internalStructPts[n];
        }
        string = string + "\nlocCrits:";
        for (n = 0; n < this.locCrits.length; ++n) {
            string = string + " " + this.locCrits[n];
        }
        string = string + "\n\nendo:" + this.endo;
        string = string + " walk:" + this.walk;
        string = string + " run:" + this.run;
        string = string + " jump:" + this.jump;
        string = string + " engRate:" + this.engineRating;
        string = string + " eng:" + this.engineType;
        string = string + " engMass:" + this.engineMass;
        string = string + " sinks:" + this.sinks;
        string = string + " doubleHS:" + this.doubleHS;
        string = string + "\n\ngyro:" + this.gyro;
        string = string + " gyMass:" + this.gyroMass;
        string = string + " iJJ:" + this.improvedJJ;
        string = string + " cpit:" + this.cockpit;
        string = string + " tsm:" + this.tsm;
        string = string + " 2xHS:" + this.doubleHS;
        string = string + " Larm:" + this.leftArm;
        string = string + " Lhand:" + this.leftHand;
        string = string + " Rarm:" + this.rightArm;
        string = string + " Rhand:" + this.rightHand;
        string = string + "\n\nArmour:" + this.armour;
        string = string + " maxArmTn:" + this.maxArmTons;
        string = string + " armTns:" + this.armourTons;
        string = string + " maxArmPts:" + this.maxArmour;
        string = string + " armPts:" + this.armourPts;
        string = string + "\nlocMaxArm:";
        for (n = 0; n < this.locMaxArmour.length; ++n) {
            string = string + " " + this.locMaxArmour[n];
        }
        string = string + "\nlocArmour:";
        for (n = 0; n < this.locArmour.length; ++n) {
            string = string + " " + this.locArmour[n];
        }
        string = string + "\n\nH:\n";
        string = string + this.locs[0].toString();
        string = string + "\nLT:\n";
        string = string + this.locs[1].toString();
        string = string + "\nCT:\n";
        string = string + this.locs[2].toString();
        string = string + "\nRT:\n";
        string = string + this.locs[3].toString();
        string = string + "\nLA:\n";
        string = string + this.locs[4].toString();
        string = string + "\nRA:\n";
        string = string + this.locs[5].toString();
        string = string + "\nLL:\n";
        string = string + this.locs[6].toString();
        string = string + "\nRL:\n";
        string = string + this.locs[7].toString();
        for (n = 0; n < this.mounts.size(); ++n) {
            string = string + this.mounts.get(n).toString() + "\n";
        }
        string = string + "\n\ncurrWgt:" + this.currWeight;
        string = string + "\n$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$\n\n";
        return string;
    }
}

