/*
 * Decompiled with CFR 0.152.
 */
public class GetTonners {
    Mech theMech;

    public GetTonners(Mech mech) {
        this.theMech = mech;
    }

    public double get(Item item) {
        if (item == null) {
            return 0.0;
        }
        if (item.id.equals("Sword")) {
            return this.sword();
        }
        if (item.id.equals("Hatchet")) {
            return this.hatchet();
        }
        if (item.id.equals("ISMASC")) {
            return this.isMasc();
        }
        if (item.id.equals("CLMASC")) {
            return this.clMasc();
        }
        if (item.id.equals("Jump Jet")) {
            return this.jjet();
        }
        if (item.id.equals("Improved Jump Jet") || item.id.equals("Clan Improved Jump Jet")) {
            return this.ijjet();
        }
        if (item.id.equals("ISTargeting Computer") || item.id.equals("CLTargeting Computer")) {
            return this.targComp();
        }
        return this.defaultGetTon(item);
    }

    private double defaultGetTon(Item item) {
        if (item.weight.equals("DoNotCount")) {
            return 0.0;
        }
        return Double.parseDouble(item.weight);
    }

    public double targComp() {
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.theMech.locCrits[i]; ++j) {
                if (this.theMech.locs[i].crits[j] == null || this.theMech.locs[i].crits[j].i == null || this.theMech.locs[i].crits[j].size == -1 || this.theMech.locs[i].crits[j].i.directFire != 1 || this.theMech.locs[i].crits[j].split) continue;
                d += this.get(this.theMech.locs[i].crits[j].i);
            }
        }
        d = this.theMech.isClan ? (d /= 5.0) : (d /= 4.0);
        d = Math.ceil(d);
        return d;
    }

    private double isMasc() {
        double d = this.theMech.tonnage / 20.0;
        return Math.ceil(d);
    }

    private double clMasc() {
        double d = this.theMech.tonnage / 25.0;
        return Math.ceil(d);
    }

    private double hatchet() {
        double d = this.theMech.tonnage / 15.0;
        return Math.ceil(d);
    }

    private double sword() {
        double d = this.theMech.tonnage / 20.0;
        return Math.ceil(d);
    }

    private double jjet() {
        if (this.theMech.tonnage <= 55.0) {
            return 0.5;
        }
        if (this.theMech.tonnage <= 85.0) {
            return 1.0;
        }
        return 2.0;
    }

    private double ijjet() {
        if (this.theMech.tonnage <= 55.0) {
            return 1.0;
        }
        if (this.theMech.tonnage <= 85.0) {
            return 2.0;
        }
        return 4.0;
    }
}

