/*
 * Decompiled with CFR 0.152.
 */
public class GetDamagers {
    int[] probs = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1};
    Mech theMech;

    public GetDamagers(Mech mech) {
        this.theMech = mech;
    }

    public double get(Item item, int n) {
        if (item == null) {
            return 0.0;
        }
        if (item.damage.equals("NA") || item.damage.equals("na") || item.damage.equals("*") || item.damage.equals("**")) {
            return 0.0;
        }
        if (item.id.equals("ISHeavyGaussRifle")) {
            return this.heavyGauss(item, n);
        }
        if (item.id.equals("CLHAG20") || item.id.equals("CLHAG30") || item.id.equals("CLHAG40")) {
            return this.hag(item, n);
        }
        if (item.id.equals("ISSNPPC")) {
            return this.snubPPC(item, n);
        }
        if (item.id.equals("CLATM3") || item.id.equals("CLATM6") || item.id.equals("CLATM9") || item.id.equals("CLATM12")) {
            return this.atm(item, n);
        }
        if (item.id.equals("ISMML3") || item.id.equals("ISMML5") || item.id.equals("ISMML7") || item.id.equals("ISMML9") || item.id.equals("ART4 ISMML3") || item.id.equals("ART4 ISMML5") || item.id.equals("ART4 ISMML7") || item.id.equals("ART4 ISMML9")) {
            return this.mml(item, n);
        }
        if (item.id.equals("ISRotaryAC2") || item.id.equals("ISRotaryAC5") || item.id.equals("CLUltraAC2") || item.id.equals("CLUltraAC5") || item.id.equals("CLUltraAC10") || item.id.equals("CLUltraAC20") || item.id.equals("ISUltraAC2") || item.id.equals("ISUltraAC5") || item.id.equals("ISUltraAC10") || item.id.equals("ISUltraAC20")) {
            return this.ultraRotaryAC(item, n);
        }
        if (item.id.equals("ISSmallPulseLaser") || item.id.equals("ISLargePulseLaser") || item.id.equals("ISMediumPulseLaser") || item.id.equals("CLMicroPulseLaser") || item.id.equals("CLSmallPulseLaser") || item.id.equals("CLMediumPulseLaser") || item.id.equals("CLLargePulseLaser")) {
            return this.pulse(item, n);
        }
        if (item.id.equals("CLHeavySmallLaser") || item.id.equals("CLHeavyMediumLaser") || item.id.equals("CLHeavyLargeLaser")) {
            return this.heavyLasers(item, n);
        }
        if (item.id.equals("MRM_10") || item.id.equals("MRM_20") || item.id.equals("MRM_30") || item.id.equals("MRM_40")) {
            return this.mrm(item, n);
        }
        if (item.id.equals("RL10") || item.id.equals("RL15") || item.id.equals("RL20")) {
            return this.rockets(item, n);
        }
        return this.defaultGetDam(item, n);
    }

    private double defaultGetDam(Item item, int n) {
        int n2 = 0;
        if (item.id.startsWith("ART4")) {
            n2 = 2;
        }
        double d = this.getBaseDam(item, n2);
        boolean bl = this.theMech.calcTargComp() && item.directFire == 1;
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, bl);
        return d2 * d;
    }

    private double atm(Item item, int n) {
        double d;
        double d2;
        int n2;
        int[] nArray;
        double d3 = 3.0;
        if (item.id.contains("6")) {
            d3 = 6.0;
        }
        if (item.id.contains("9")) {
            d3 = 9.0;
        }
        if (item.id.contains("12")) {
            d3 = 12.0;
        }
        boolean bl = this.theMech.countItem("Clan Ammo ATM-" + (int)d3 + " ER") > 0;
        boolean bl2 = this.theMech.countItem("Clan Ammo ATM-" + (int)d3) > 0;
        boolean bl3 = this.theMech.countItem("Clan Ammo ATM-" + (int)d3 + " HE") > 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (bl) {
            nArray = new int[]{4, 9, 18, 27};
            n2 = 1;
            d2 = (double)n2 * this.getClusterColmAverage((int)d3, 2);
            d = this.getToHitProb(n, nArray, false);
            d6 = d * d2;
        }
        if (bl2) {
            nArray = new int[]{4, 5, 10, 15};
            n2 = 2;
            d2 = (double)n2 * this.getClusterColmAverage((int)d3, 2);
            d = this.getToHitProb(n, nArray, false);
            d5 = d * d2;
        }
        if (bl3) {
            nArray = new int[]{0, 3, 6, 9};
            n2 = 3;
            d2 = (double)n2 * this.getClusterColmAverage((int)d3, 2);
            d = this.getToHitProb(n, nArray, false);
            d4 = d * d2;
        }
        return Math.max(d4, Math.max(d5, d6));
    }

    private double mml(Item item, int n) {
        double d;
        double d2;
        int n2;
        int n3;
        int[] nArray;
        double d3 = 3.0;
        if (item.id.contains("5")) {
            d3 = 5.0;
        }
        if (item.id.contains("7")) {
            d3 = 7.0;
        }
        if (item.id.contains("9")) {
            d3 = 9.0;
        }
        String[] stringArray = new String[]{"IS Ammo MML-" + (int)d3 + " LRM", "IS Ammo MML-" + (int)d3 + " LRM Artemis-capable", "IS Ammo MML-" + (int)d3 + " LRM Narc-capable", "IS Ammo MML-" + (int)d3 + " LRM Fragmentation"};
        String[] stringArray2 = new String[]{"IS Ammo MML-" + (int)d3 + " SRM", "IS Ammo MML-" + (int)d3 + " SRM Artemis-capable", "IS Ammo MML-" + (int)d3 + " SRM Narc-capable", "IS Ammo MML-" + (int)d3 + " SRM Fragmentation"};
        boolean bl = this.theMech.countItem(stringArray) > 0;
        boolean bl2 = this.theMech.countItem(stringArray2) > 0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (bl) {
            nArray = new int[]{6, 7, 14, 21};
            n3 = 1;
            n2 = 0;
            if (item.id.startsWith("ART4")) {
                n2 = 2;
            }
            d2 = (double)n3 * this.getClusterColmAverage((int)d3, n2);
            d = this.getToHitProb(n, nArray, false);
            d5 = d * d2;
        }
        if (bl2) {
            nArray = new int[]{0, 3, 6, 9};
            n3 = 2;
            n2 = 0;
            if (item.id.startsWith("ART4")) {
                n2 = 2;
            }
            d2 = (double)n3 * this.getClusterColmAverage((int)d3, n2);
            d = this.getToHitProb(n, nArray, false);
            d4 = d * d2;
        }
        return Math.max(d4, d5);
    }

    private double hag(Item item, int n) {
        int[] nArray = this.theMech.getRange.get(item);
        int n2 = 0;
        if (n > nArray[0] && n <= nArray[1]) {
            n2 = 2;
        }
        if (n > nArray[2] && n <= nArray[3]) {
            n2 = -2;
        }
        double d = this.getBaseDam(item, n2);
        double d2 = this.getToHitProb(n, nArray, this.theMech.calcTargComp());
        return d2 * d;
    }

    private double heavyGauss(Item item, int n) {
        int[] nArray = this.theMech.getRange.get(item);
        double d = 25.0;
        if (n > nArray[1]) {
            d = 20.0;
        }
        if (n > nArray[2]) {
            d = 10.0;
        }
        double d2 = this.getToHitProb(n, nArray, this.theMech.calcTargComp());
        return d2 * d;
    }

    private double snubPPC(Item item, int n) {
        int[] nArray = this.theMech.getRange.get(item);
        double d = 10.0;
        if (n > nArray[1]) {
            d = 8.0;
        }
        if (n > nArray[2]) {
            d = 5.0;
        }
        double d2 = this.getToHitProb(n, nArray, this.theMech.calcTargComp());
        return d2 * d;
    }

    private double ultraRotaryAC(Item item, int n) {
        double d = this.getBaseDam(item, 0);
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, false);
        return d2 * d;
    }

    private double pulse(Item item, int n) {
        double d = this.getBaseDam(item, 0);
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, false, -2);
        return d2 * d;
    }

    private double rockets(Item item, int n) {
        double d = this.getBaseDam(item, 0);
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, false, 1);
        return d2 * d;
    }

    private double heavyLasers(Item item, int n) {
        double d = this.getBaseDam(item, 0);
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, true, 1);
        return d2 * d;
    }

    private double mrm(Item item, int n) {
        double d = this.getBaseDam(item, 0);
        int[] nArray = this.theMech.getRange.get(item);
        double d2 = this.getToHitProb(n, nArray, false, 1);
        return d2 * d;
    }

    private double getBaseDam(Item item, int n) {
        try {
            if (item.damage.contains("x")) {
                String[] stringArray = item.damage.split("x");
                double d = Double.parseDouble(stringArray[0]);
                double d2 = this.getClusterColmAverage(Integer.parseInt(stringArray[1]), n);
                return d * d2;
            }
            return Integer.parseInt(item.damage);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private double getToHitProb(int n, int[] nArray, boolean bl) {
        return this.getToHitProb(n, nArray, bl, 0);
    }

    private double getToHitProb(int n, int[] nArray, boolean bl, int n2) {
        if (n == 0) {
            n = nArray[1];
        }
        int n3 = 4;
        if (n > nArray[3]) {
            n3 = 999;
        } else if (n > nArray[2]) {
            n3 += 4;
        } else if (n > nArray[1]) {
            n3 += 2;
        } else if (n <= nArray[0]) {
            n3 = 999;
        }
        if (bl) {
            --n3;
        }
        if ((n3 += n2) > 12) {
            return 0.0;
        }
        if (n3 <= 2) {
            return 1.0;
        }
        int n4 = 0;
        for (int i = n3; i <= 12; ++i) {
            n4 += this.probs[i];
        }
        return (double)n4 / 36.0;
    }

    private double getClusterColmAverage(int n, int n2) {
        int n3;
        int n4;
        if (n == 40) {
            n = 31;
        }
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2}, {1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3}, {1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4}, {1, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5}, {2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6}, {2, 2, 3, 4, 4, 4, 4, 6, 6, 7, 7}, {3, 3, 4, 4, 5, 5, 5, 6, 6, 8, 8}, {3, 3, 4, 5, 5, 5, 5, 7, 7, 9, 9}, {3, 3, 4, 6, 6, 6, 6, 8, 8, 10, 10}, {4, 4, 5, 7, 7, 7, 7, 9, 9, 11, 11}, {4, 4, 5, 8, 8, 8, 8, 10, 10, 12, 12}, {4, 4, 5, 8, 8, 8, 8, 11, 11, 13, 13}, {5, 5, 6, 9, 9, 9, 9, 11, 11, 14, 14}, {5, 5, 6, 9, 9, 9, 9, 12, 12, 15, 15}, {5, 5, 7, 10, 10, 10, 10, 13, 13, 16, 16}, {5, 5, 7, 10, 10, 10, 10, 14, 14, 17, 17}, {6, 6, 8, 11, 11, 11, 11, 14, 14, 18, 18}, {6, 6, 7, 11, 11, 11, 11, 15, 15, 19, 19}, {6, 6, 9, 12, 12, 12, 12, 16, 16, 20, 20}, {7, 7, 9, 13, 13, 13, 13, 17, 17, 21, 21}, {7, 7, 9, 14, 14, 14, 14, 18, 18, 22, 22}, {7, 7, 10, 15, 15, 15, 15, 19, 19, 23, 23}, {8, 8, 10, 16, 16, 16, 16, 20, 20, 24, 24}, {8, 8, 10, 16, 16, 16, 16, 21, 21, 25, 25}, {9, 9, 11, 17, 17, 17, 17, 21, 21, 26, 26}, {9, 9, 11, 17, 17, 17, 17, 22, 22, 27, 27}, {9, 9, 11, 17, 17, 17, 17, 23, 23, 28, 28}, {10, 10, 12, 18, 18, 18, 18, 23, 23, 29, 29}, {10, 10, 12, 18, 18, 18, 18, 24, 24, 30, 30}, {12, 12, 18, 24, 24, 24, 24, 32, 32, 40, 40}};
        int[] nArray = nArrayArray[n];
        if (n2 < 0) {
            n4 = nArray[0];
            for (n3 = 10; n3 >= 0; --n3) {
                nArray[n3] = n3 + n2 >= 0 ? nArray[n3 + n2] : n4;
            }
        }
        if (n2 > 0) {
            n4 = nArray[10];
            for (n3 = 0; n3 < 11; ++n3) {
                nArray[n3] = n3 + n2 < 11 ? nArray[n3 + n2] : n4;
            }
        }
        double d = nArray[0] + 2 * nArray[1] + 3 * nArray[2] + 4 * nArray[3] + 5 * nArray[4] + 6 * nArray[5] + 5 * nArray[6] + 4 * nArray[7] + 3 * nArray[8] + 2 * nArray[9] + nArray[10];
        return d / 36.0;
    }
}

