/*
 * Decompiled with CFR 0.152.
 */
public class GetCosters {
    Mech theMech;

    public GetCosters(Mech mech) {
        this.theMech = mech;
    }

    public double get(Item item, int n) {
        if (item == null) {
            return 0.0;
        }
        if (item.id.equals("CLTargeting Computer") || item.id.equals("ISTargeting Computer")) {
            return this.targComp(item);
        }
        if (item.id.equals("Sword")) {
            return this.sword(item);
        }
        if (item.id.equals("Hatchet")) {
            return this.hatchet(item);
        }
        if (item.id.equals("ISMGA\t")) {
            return this.isMGA(item, n);
        }
        if (item.id.equals("ISHMGA\t")) {
            return this.isHMGA(item, n);
        }
        if (item.id.equals("ISLMGA\t")) {
            return this.isLMGA(item, n);
        }
        if (item.id.equals("CLMGA\t")) {
            return this.clMGA(item, n);
        }
        if (item.id.equals("CLHMGA\t")) {
            return this.clHMGA(item, n);
        }
        if (item.id.equals("CLLMGA\t")) {
            return this.clLMGA(item, n);
        }
        return this.defaultGetCost(item);
    }

    private double defaultGetCost(Item item) {
        double d = 0.0;
        try {
            d = Integer.parseInt(item.cost);
        }
        catch (Exception exception) {
            return 0.0;
        }
        return d;
    }

    private double hatchet(Item item) {
        return 5000.0 * this.theMech.getTon.get(new Item("Hatchet"));
    }

    private double sword(Item item) {
        return 10000.0 * this.theMech.getTon.get(new Item("Sword"));
    }

    private double targComp(Item item) {
        return 10000.0 * this.theMech.getTon.get(new Item(item.id));
    }

    private double isMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("Machine Gun");
        return 0.67 * (double)n2 * 5.0;
    }

    private double isLMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("Light Machine Gun");
        return 0.67 * (double)n2 * 5.0;
    }

    private double isHMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("Heavy Machine Gun");
        return 0.67 * (double)n2 * 6.0;
    }

    private double clMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("CLMG");
        return 0.67 * (double)n2 * 5.0;
    }

    private double clLMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("CLLightMG");
        return 0.67 * (double)n2 * 5.0;
    }

    private double clHMGA(Item item, int n) {
        int n2 = this.theMech.locs[n].count("CLHeavyMG");
        return 0.67 * (double)n2 * 6.0;
    }
}

