/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class BtMechBuilder {
    private final String version = "QuickMech v0.4";
    private final String twoLegFormImage = "twoLegForm.png";
    private final String fourLegFormImage = "fourLegForm.png";
    private final String twoLegFormLocs = "twoLegFormLocs";
    private final String fourLegFormLocs = "fourLegFormLocs";
    private final String isWeaponsFile = "isWeapons";
    private final String isAmmoFile = "isAmmo";
    private final String clanWeaponsFile = "clanWeapons";
    private final String clanAmmoFile = "clanAmmo";
    private final String[] tonnages = new String[]{"20 tons", "25 tons", "30 tons", "35 tons", "40 tons", "45 tons", "50 tons", "55 tons", "60 tons", "65 tons", "70 tons", "75 tons", "80 tons", "85 tons", "90 tons", "95 tons", "100 tons"};
    private final String[] walks = new String[]{"Speed: 1/2", "Speed: 2/3", "Speed: 3/5", "Speed: 4/6", "Speed: 5/8", "Speed: 6/9", "Speed: 7/11", "Speed: 8/12", "Speed: 9/14", "Speed: 10/15", "Speed: 11/17", "Speed: 12/18", "Speed: 13/20", "Speed: 14/21", "Speed: 15/23", "Speed: 16/24", "Speed: 17/25", "Speed: 18/27", "Speed: 19/29", "Speed: 20/30"};
    private final int critsCLdoubleHS = 2;
    private final int critsISdoubleHS = 3;
    private final int critsSingleHS = 1;
    private final int critsTSM = 6;
    private final int critsArm = 1;
    private final int critsHand = 1;
    private final int critsISendo = 14;
    private final int critsCLendo = 7;
    private final int[] critsEngIS = new int[]{6, 3, 10, 12};
    private final int[] critsEngCL = new int[]{6, 10};
    private final int[] critsGyroCL = new int[]{4};
    private final int[] critsGyroIS = new int[]{4, 2, 4, 6};
    private final int[] critsCockpitIS = new int[]{2, 1};
    private final int[] critsCockpitCL = new int[]{2};
    private final int[] critsArmourIS = new int[]{0, 12, 7, 14, 21};
    private final int[] critsArmourCL = new int[]{0, 7};
    private final int CI = 0;
    private final int SW = 1;
    private final int SL = 2;
    private final int All = 3;
    private final String[] eras = new String[]{"Era: Clan Invasion - Present", "Era: Succession Wars", "Era: Pre-War/Star-League", "Era: All"};
    private final int[][] eraYears = new int[][]{{3051, 3085, 3085}, {2801, 3050, 3050}, {2443, 2800, 2800}, {2443, 3085, 3085}};
    private String[] isEngines;
    private final String[][] eraIsEngines = new String[][]{{"Engine: Standard", "Engine: Compact", "Engine: Light", "Engine: XL"}, {"Engine: Standard", "Engine: XL"}, {"Engine: Standard", "Engine: XL"}, {"Engine: Standard", "Engine: Compact", "Engine: Light", "Engine: XL"}};
    private String[] clanEngines;
    private final String[][] eraClanEngines = new String[][]{{"Engine: Standard", "Engine: XL"}, {"Engine: Standard", "Engine: XL"}, {"err: did not exist"}, {"Engine: Standard", "Engine: XL"}};
    private String[] isGyros;
    private final String[][] eraIsGyros = new String[][]{{"Gyro: Standard", "Gyro: Compact", "Gyro: Heavy-Duty", "Gyro: XL"}, {"Gyro: Standard"}, {"Gyro: Standard"}, {"Gyro: Standard", "Gyro: Compact", "Gyro: Heavy-Duty", "Gyro: XL"}};
    private String[] clanGyros;
    private final String[][] eraClanGyros = new String[][]{{"Gyro: Standard"}, {"Gyro: Standard"}, {"err did not exist"}, {"Gyro: Standard"}};
    private String[] isCockpits;
    private final String[][] eraIsCockpits = new String[][]{{"Cockpit: Standard", "Cockpit: Small"}, {"Cockpit: Standard"}, {"Cockpit: Standard"}, {"Cockpit: Standard", "Cockpit: Small"}};
    private String[] clanCockpits;
    private final String[][] eraClanCockpits = new String[][]{{"Cockpit: Standard"}, {"Cockpit: Standard"}, {"err didnt exist"}, {"Cockpit: Standard"}};
    private String[] isArmours;
    private final String[][] eraIsArmours = new String[][]{{"Armour: Standard", "Armour: Stealth", "Armour: Light Ferro-Fibrous", "Armour: Ferro-Fibrous", "Armour: Heavy Ferro-Fibrous"}, {"Armour: Standard", "Armour: Ferro-Fibrous"}, {"Armour: Standard", "Armour: Ferro-Fibrous"}, {"Armour: Standard", "Armour: Stealth", "Armour: Light Ferro-Fibrous", "Armour: Ferro-Fibrous", "Armour: Heavy Ferro-Fibrous"}};
    private String[] clanArmours;
    private final String[][] eraClanArmours = new String[][]{{"Armour: Standard", "Armour: Ferro-Fibrous"}, {"Armour: Standard", "Armour: Ferro-Fibrous"}, {"err didnt exist"}, {"Armour: Standard", "Armour: Ferro-Fibrous"}};
    private final int maxEngineRating = 400;
    private final int H = 0;
    private final int LT = 1;
    private final int CT = 2;
    private final int RT = 3;
    private final int LA = 4;
    private final int RA = 5;
    private final int LL = 6;
    private final int RL = 7;
    private final int rLT = 8;
    private final int rCT = 9;
    private final int rRT = 10;
    ArrayList<ArrayList<String>> mtfNames;
    Mech theMech;
    Color backCol;
    private JFrame frame;
    private JPanel mainPanel;
    private MyDrawPanel sheetPanel;
    private JScrollPane weapsTreeScrollPane;
    private MyWeaponsTree weapsTree;
    private JRadioButton twoLegRadio;
    private JRadioButton fourLegRadio;
    private ButtonGroup structureGroup;
    private JRadioButton isRadio;
    private JRadioButton clanRadio;
    private ButtonGroup techBaseGroup;
    private JCheckBox omniBox;
    private JButton lockButton;
    private JTextField nameField;
    private JTextField variantField;
    private JComboBox tonnageCombo;
    private JRadioButton standardStructRadio;
    private JRadioButton endoRadio;
    private ButtonGroup internalStructGroup;
    private JComboBox walksCombo;
    private JComboBox engineCombo;
    private JComboBox gyroCombo;
    private JComboBox cockpitCombo;
    public JCheckBox tsmBox;
    private JCheckBox leftArmBox;
    private JCheckBox leftHandBox;
    private JCheckBox rightArmBox;
    private JCheckBox rightHandBox;
    private JComboBox armourCombo;
    private JLabel armourLabel2;
    private JSpinner armHSpin;
    private JLabel armHLabel;
    private JSpinner armLTSpin;
    private JLabel armLTLabel;
    private JSpinner armCTSpin;
    private JLabel armCTLabel;
    private JSpinner armRTSpin;
    private JLabel armRTLabel;
    private JSpinner armRearLTSpin;
    private JLabel armRearLTLabel;
    private JSpinner armRearCTSpin;
    private JLabel armRearCTLabel;
    private JSpinner armRearRTSpin;
    private JLabel armRearRTLabel;
    private JSpinner armLASpin;
    private JLabel armLALabel;
    private JSpinner armRASpin;
    private JLabel armRALabel;
    private JSpinner armLLSpin;
    private JLabel armLLLabel;
    private JSpinner armRLSpin;
    private JLabel armRLLabel;
    private JButton saveBtn;
    private JButton loadBtn;
    private JButton aboutBtn;
    public JLabel statusLabel;
    private JLabel massLabel;
    private JLabel critsLabel;
    private JRadioButton stdHSRadio;
    private JRadioButton dblHSRadio;
    private ButtonGroup hsGroup;
    public JSpinner hsSpin;
    private JLabel hsLabel;
    private JButton amrFillBtn;
    private JButton amrClearBtn;
    private String msg;
    private JLabel eraLabel;
    private JTextField erabox;
    private JComboBox eraCombo;
    private JLabel saveLabel;
    private JButton addAmrBtn;
    private JButton subAmrBtn;
    private JButton hideButton;
    private boolean hiding = false;
    private MyDiagPanel diagramPanel;
    File loadPath = new File(".");
    Adders adder;

    private void pressedTwoLegRadio() {
        if (this.theMech.isFourLegger) {
            this.theMech.isFourLegger = false;
            this.sheetPanel.changeImage("twoLegForm.png", "twoLegFormLocs");
            this.leftArmBox.setEnabled(true);
            this.leftHandBox.setEnabled(true);
            this.rightArmBox.setEnabled(true);
            this.rightHandBox.setEnabled(true);
            this.clearTheMech();
            this.updateForm();
        }
    }

    private void pressedFourLegRadio() {
        if (!this.theMech.isFourLegger) {
            this.theMech.isFourLegger = true;
            this.sheetPanel.changeImage("fourLegForm.png", "fourLegFormLocs");
            this.leftArmBox.setEnabled(false);
            this.leftHandBox.setEnabled(false);
            this.rightArmBox.setEnabled(false);
            this.rightHandBox.setEnabled(false);
            this.clearTheMech();
            this.updateForm();
        }
    }

    private void pressedIsRadio(boolean bl) {
        if (this.theMech.isClan) {
            this.theMech.isClan = false;
            if (bl) {
                this.clearTheMech();
            }
            this.updateTrees("isWeapons", "isAmmo");
            this.replaceComboItems(this.engineCombo, this.isEngines);
            this.replaceComboItems(this.gyroCombo, this.isGyros);
            this.replaceComboItems(this.cockpitCombo, this.isCockpits);
            if (this.theMech.era == 0 || this.theMech.era == 3) {
                this.tsmBox.setEnabled(true);
            }
            this.replaceComboItems(this.armourCombo, this.isArmours);
            if (bl) {
                this.updateForm();
            }
        }
    }

    private void pressedClanRadio() {
        if (!this.theMech.isClan) {
            this.theMech.isClan = true;
            this.clearTheMech();
            this.updateTrees("clanWeapons", "clanAmmo");
            this.replaceComboItems(this.engineCombo, this.clanEngines);
            this.replaceComboItems(this.gyroCombo, this.clanGyros);
            this.replaceComboItems(this.cockpitCombo, this.clanCockpits);
            this.tsmBox.setEnabled(false);
            this.replaceComboItems(this.armourCombo, this.clanArmours);
            this.updateForm();
        }
    }

    private void updateTrees(String string, String string2) {
        this.weapsTree = new MyWeaponsTree(this, this.theMech, new MyCustomMutableTreeNode((Object)"Weapons and Equipment       Ht  Dam  Mi/Sh/Me/Lo  Am Wgt Cr", "root.png"), string);
        this.weapsTreeScrollPane.setViewportView(this.weapsTree);
        this.weapsTree.setToggleClickCount(1);
    }

    private void pressedOmniBox() {
        this.theMech.isOmni = !this.theMech.isOmni;
        this.clearTheMech();
        this.updateForm();
    }

    private void pressedEra(int n) {
        this.clearTheMech();
        this.theMech.era = n;
        this.erabox.setText("" + this.eraYears[n][2]);
        this.isEngines = this.eraIsEngines[n];
        this.clanEngines = this.eraClanEngines[n];
        this.isGyros = this.eraIsGyros[n];
        this.clanGyros = this.eraClanGyros[n];
        this.isCockpits = this.eraIsCockpits[n];
        this.clanCockpits = this.eraClanCockpits[n];
        this.isArmours = this.eraIsArmours[n];
        this.clanArmours = this.eraClanArmours[n];
        if (n == 2) {
            this.clanRadio.setEnabled(false);
            this.tsmBox.setEnabled(false);
            this.theMech.isClan = false;
            this.updateTrees("isWeapons", "isAmmo");
            this.isRadio.setSelected(true);
        }
        if (n == 1) {
            this.clanRadio.setEnabled(true);
            this.tsmBox.setEnabled(false);
            if (this.theMech.isClan) {
                this.updateTrees("clanWeapons", "clanAmmo");
            } else {
                this.updateTrees("isWeapons", "isAmmo");
            }
        }
        if (n == 0) {
            this.clanRadio.setEnabled(true);
            this.tsmBox.setEnabled(true);
            if (this.theMech.isClan) {
                this.updateTrees("clanWeapons", "clanAmmo");
            } else {
                this.updateTrees("isWeapons", "isAmmo");
            }
        }
        if (n == 3) {
            this.clanRadio.setEnabled(true);
            this.tsmBox.setEnabled(true);
            if (this.theMech.isClan) {
                this.updateTrees("clanWeapons", "clanAmmo");
            } else {
                this.updateTrees("isWeapons", "isAmmo");
            }
        }
        if (this.theMech.isClan) {
            this.replaceComboItems(this.engineCombo, this.clanEngines);
            this.replaceComboItems(this.gyroCombo, this.clanGyros);
            this.replaceComboItems(this.cockpitCombo, this.clanCockpits);
            this.replaceComboItems(this.armourCombo, this.clanArmours);
        } else {
            this.replaceComboItems(this.engineCombo, this.isEngines);
            this.replaceComboItems(this.gyroCombo, this.isGyros);
            this.replaceComboItems(this.cockpitCombo, this.isCockpits);
            this.replaceComboItems(this.armourCombo, this.isArmours);
        }
        this.updateForm();
    }

    private void pressedLock() {
        if (this.omniBox.isEnabled()) {
            this.omniBox.setEnabled(false);
            this.clanRadio.setEnabled(false);
            this.isRadio.setEnabled(false);
            this.twoLegRadio.setEnabled(false);
            this.fourLegRadio.setEnabled(false);
            this.tonnageCombo.setEnabled(false);
            this.lockButton.setText("Unlock");
        } else {
            this.omniBox.setEnabled(true);
            if (this.theMech.era != 2) {
                this.clanRadio.setEnabled(true);
            }
            this.isRadio.setEnabled(true);
            this.twoLegRadio.setEnabled(true);
            this.fourLegRadio.setEnabled(true);
            this.tonnageCombo.setEnabled(true);
            this.lockButton.setText("Lock");
        }
    }

    private void changedName(String string) {
        this.theMech.name = string;
        this.updateForm();
    }

    private void changedVar(String string) {
        this.theMech.variant = string;
        this.updateForm();
    }

    private void pressedTonnage(String string) {
        int n;
        this.theMech.tonnage = Integer.parseInt(string.substring(0, 3).trim());
        this.clearTheMech();
        int n2 = (int)(400.0 / this.theMech.tonnage);
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = this.walks[n];
        }
        for (n = 0; n < n2; ++n) {
            this.replaceComboItems(this.walksCombo, stringArray);
        }
        this.updateForm();
    }

    private void pressedStandardStructRadio() {
        if (this.theMech.endo) {
            this.theMech.endo = false;
            this.updateForm();
        }
    }

    private void pressedEndoRadio() {
        if (!this.theMech.endo) {
            int n = 14;
            if (this.theMech.isClan) {
                n = 7;
            }
            if (this.theMech.totalEmptyCrits() >= n) {
                this.theMech.endo = true;
                this.updateForm();
            } else {
                this.standardStructRadio.setSelected(true);
                this.statusLabel.setText(this.statusLabel.getText() + "Not enough space for endo steel.  --  ");
            }
        }
    }

    private void pressedWalk(String string) {
        if (string == null) {
            this.theMech.walk = 1;
            this.theMech.run = 2;
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(7), "/");
            this.theMech.walk = Integer.parseInt(stringTokenizer.nextToken());
            this.theMech.run = Integer.parseInt(stringTokenizer.nextToken());
        }
        this.updateForm();
    }

    private void pressedEngine(String string) {
        if (string == null) {
            this.theMech.engineType = "Standard";
            this.updateForm();
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.theMech.isClan) {
            n = this.critsEngCL[0];
            if (this.theMech.engineType.equals("XL")) {
                n = this.critsEngCL[1];
                n2 = 1;
            }
            n3 = this.critsEngCL[this.engineCombo.getSelectedIndex()];
        } else {
            n = this.critsEngIS[0];
            if (this.theMech.engineType.equals("Compact")) {
                n = this.critsEngIS[1];
                n2 = 1;
            }
            if (this.theMech.engineType.equals("Light")) {
                n = this.critsEngIS[2];
                n2 = 2;
            }
            if (this.theMech.engineType.equals("XL")) {
                n = this.critsEngIS[3];
                n2 = 3;
            }
            n3 = this.critsEngIS[this.engineCombo.getSelectedIndex()];
        }
        int n4 = n3 - n;
        if (this.theMech.totalEmptyCrits() >= n4) {
            this.theMech.engineType = string.substring(8);
            this.updateForm();
        } else {
            this.engineCombo.setSelectedIndex(n2);
            this.statusLabel.setText(this.statusLabel.getText() + "Not enough space to change engine.  --  ");
        }
    }

    private void pressedGyro(String string) {
        if (string == null) {
            this.theMech.gyro = "Standard";
            this.updateForm();
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.theMech.isClan) {
            n = this.critsGyroCL[0];
            n3 = this.critsGyroCL[this.gyroCombo.getSelectedIndex()];
        } else {
            n = this.critsGyroIS[0];
            if (this.theMech.gyro.equals("Compact")) {
                n = this.critsGyroIS[1];
                n2 = 1;
            }
            if (this.theMech.gyro.equals("Heavy-Duty")) {
                n = this.critsGyroIS[2];
                n2 = 2;
            }
            if (this.theMech.gyro.equals("Light")) {
                n = this.critsGyroIS[3];
                n2 = 3;
            }
            n3 = this.critsGyroIS[this.gyroCombo.getSelectedIndex()];
        }
        int n4 = n3 - n;
        if (this.theMech.totalEmptyCrits() >= n4) {
            this.theMech.gyro = string.substring(6);
            this.updateForm();
        } else {
            this.gyroCombo.setSelectedIndex(n2);
            this.statusLabel.setText(this.statusLabel.getText() + "Not enough space to change gyro.  --  ");
        }
    }

    private void pressedCockpit(String string) {
        if (string == null) {
            this.theMech.cockpit = "Standard";
            this.updateForm();
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.theMech.isClan) {
            n = this.critsCockpitCL[0];
            n3 = this.critsCockpitCL[this.cockpitCombo.getSelectedIndex()];
        } else {
            n = this.critsCockpitIS[0];
            if (this.theMech.cockpit.equals("Small")) {
                n = this.critsCockpitIS[1];
                n2 = 1;
            }
            n3 = this.critsCockpitIS[this.cockpitCombo.getSelectedIndex()];
        }
        int n4 = n3 - n;
        if (this.theMech.totalEmptyCrits() >= n4) {
            this.theMech.cockpit = string.substring(9);
            this.updateForm();
        } else {
            this.cockpitCombo.setSelectedIndex(n2);
            this.statusLabel.setText(this.statusLabel.getText() + "Not enough space to change cockpit.  --  ");
        }
    }

    private void pressedTSM() {
        if (this.theMech.tsm) {
            this.theMech.tsm = false;
        } else if (this.theMech.totalEmptyCrits() >= 6) {
            if (this.theMech.countItem("ISMASC") == 0) {
                this.theMech.tsm = true;
            } else {
                this.statusLabel.setText(this.statusLabel.getText() + "TSM cannot be installed with MASC.  --  ");
                this.tsmBox.setSelected(false);
            }
        } else {
            this.statusLabel.setText(this.statusLabel.getText() + "Not enough space to install TSM.  --  ");
            this.tsmBox.setSelected(false);
        }
        this.updateForm();
    }

    private void pressedArmour(String string) {
        if (string == null) {
            this.theMech.armour = "Standard";
            this.updateForm();
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.theMech.isClan) {
            n = this.critsArmourCL[0];
            if (this.theMech.armour.equals("Ferro-Fibrous")) {
                n = this.critsArmourCL[1];
                n2 = 1;
            }
            n3 = this.critsArmourCL[this.armourCombo.getSelectedIndex()];
        } else {
            n = this.critsArmourIS[0];
            if (this.theMech.armour.equals("Stealth")) {
                n = this.critsArmourIS[1];
                n2 = 1;
            }
            if (this.theMech.armour.equals("Light Ferro-Fibrous")) {
                n = this.critsArmourIS[2];
                n2 = 2;
            }
            if (this.theMech.armour.equals("Ferro-Fibrous")) {
                n = this.critsArmourIS[3];
                n2 = 3;
            }
            if (this.theMech.armour.equals("Heavy Ferro-Fibrous")) {
                n = this.critsArmourIS[4];
                n2 = 4;
            }
            n3 = this.critsArmourIS[this.armourCombo.getSelectedIndex()];
        }
        int n4 = n3 - n;
        if (this.theMech.totalEmptyCrits() >= n4) {
            this.theMech.armour = string.substring(8);
            this.updateForm();
        } else {
            this.armourCombo.setSelectedIndex(n2);
            this.statusLabel.setText("Not enough space to change armour type.  --  " + this.statusLabel.getText());
        }
    }

    private void pressedLeftArm() {
        if (this.theMech.leftArm) {
            this.theMech.leftArm = false;
            this.theMech.leftHand = false;
            this.leftHandBox.setSelected(false);
        } else {
            this.theMech.leftArm = true;
        }
        this.updateForm();
    }

    private void pressedLeftHand() {
        if (this.theMech.leftHand) {
            this.theMech.leftHand = false;
        } else {
            this.theMech.leftArm = true;
            this.theMech.leftHand = true;
            this.leftArmBox.setSelected(true);
        }
        this.updateForm();
    }

    private void pressedRightArm() {
        if (this.theMech.rightArm) {
            this.theMech.rightArm = false;
            this.theMech.rightHand = false;
            this.rightHandBox.setSelected(false);
        } else {
            this.theMech.rightArm = true;
        }
        this.updateForm();
    }

    private void pressedRightHand() {
        if (this.theMech.rightHand) {
            this.theMech.rightHand = false;
        } else {
            this.theMech.rightArm = true;
            this.theMech.rightHand = true;
            this.rightArmBox.setSelected(true);
        }
        this.updateForm();
    }

    private void pressedStdHSRadio() {
        if (this.theMech.doubleHS) {
            this.theMech.doubleHS = false;
            this.updateForm();
        }
    }

    private void pressedDblHSRadio() {
        if (!this.theMech.doubleHS) {
            int n;
            int n2 = Math.max(0, this.theMech.sinks - this.theMech.calcFreeHS());
            int n3 = 3;
            if (this.theMech.isClan) {
                n3 = 2;
            }
            if ((n3 - 1) * n2 <= (n = this.theMech.totalEmptyCrits())) {
                this.theMech.doubleHS = true;
                this.updateForm();
            } else {
                this.stdHSRadio.setSelected(true);
                this.statusLabel.setText("Not enough space to convert all mounted HS to Double HS.  --  " + this.statusLabel.getText());
            }
        }
    }

    private void pressedAutoClear() {
        this.armCTSpin.setValue(0);
        this.armRTSpin.setValue(0);
        this.armLTSpin.setValue(0);
        this.armRASpin.setValue(0);
        this.armRLSpin.setValue(0);
        this.armLLSpin.setValue(0);
        this.armLASpin.setValue(0);
        this.armHSpin.setValue(0);
        this.armRearLTSpin.setValue(0);
        this.armRearRTSpin.setValue(0);
        this.armRearCTSpin.setValue(0);
        this.updateForm();
    }

    private void pressedAutoFill() {
        double d = this.theMech.tonnage - this.theMech.currWeight + this.theMech.armourTons;
        if (this.theMech.maxArmTons < d) {
            d = this.theMech.maxArmTons;
        }
        double d2 = 1.0;
        if (this.theMech.armour.equals("Light Ferro-Fibrous")) {
            d2 = 1.06;
        }
        if (this.theMech.armour.equals("Heavy Ferro-Fibrous")) {
            d2 = 1.24;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && this.theMech.isClan) {
            d2 = 1.2;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && !this.theMech.isClan) {
            d2 = 1.12;
        }
        int n = (int)(d * 16.0 * d2);
        if (d == this.theMech.maxArmTons) {
            n = this.theMech.maxArmour;
        }
        this.addAmrPoints(n);
        this.updateForm();
    }

    public void pressedSubAmr() {
        if (this.theMech.armourTons <= 0.0) {
            return;
        }
        this.theMech.armourTons -= 0.5;
        double d = 1.0;
        if (this.theMech.armour.equals("Light Ferro-Fibrous")) {
            d = 1.06;
        }
        if (this.theMech.armour.equals("Heavy Ferro-Fibrous")) {
            d = 1.24;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && this.theMech.isClan) {
            d = 1.2;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && !this.theMech.isClan) {
            d = 1.12;
        }
        int n = (int)(this.theMech.armourTons * 16.0 * d);
        if (this.theMech.armourTons == this.theMech.maxArmTons) {
            n = this.theMech.maxArmour;
        }
        this.addAmrPoints(n);
        this.updateForm();
    }

    public void pressedAddAmr() {
        if (this.theMech.armourTons >= this.theMech.maxArmTons) {
            return;
        }
        this.theMech.armourTons += 0.5;
        double d = 1.0;
        if (this.theMech.armour.equals("Light Ferro-Fibrous")) {
            d = 1.06;
        }
        if (this.theMech.armour.equals("Heavy Ferro-Fibrous")) {
            d = 1.24;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && this.theMech.isClan) {
            d = 1.2;
        }
        if (this.theMech.armour.equals("Ferro-Fibrous") && !this.theMech.isClan) {
            d = 1.12;
        }
        int n = (int)(this.theMech.armourTons * 16.0 * d);
        if (this.theMech.armourTons == this.theMech.maxArmTons) {
            n = this.theMech.maxArmour;
        }
        this.addAmrPoints(n);
        this.updateForm();
    }

    public void addAmrPoints(int n) {
        int[] nArray = new int[11];
        int n2 = 1;
        while (n > 0) {
            switch (n2 % 6) {
                case 0: {
                    if (nArray[0] < this.theMech.locMaxArmour[0] && n > 0) {
                        nArray[0] = nArray[0] + 1;
                        --n;
                    }
                }
                case 1: 
                case 2: {
                    if (nArray[4] < this.theMech.locMaxArmour[4] && n > 0) {
                        nArray[4] = nArray[4] + 1;
                        --n;
                    }
                    if (nArray[5] < this.theMech.locMaxArmour[5] && n > 0) {
                        nArray[5] = nArray[5] + 1;
                        --n;
                    }
                }
                case 3: {
                    if (nArray[6] < this.theMech.locMaxArmour[6] && n > 0) {
                        nArray[6] = nArray[6] + 1;
                        --n;
                    }
                    if (nArray[7] < this.theMech.locMaxArmour[7] && n > 0) {
                        nArray[7] = nArray[7] + 1;
                        --n;
                    }
                    if (nArray[1] < this.theMech.locMaxArmour[1] && n > 0) {
                        nArray[1] = nArray[1] + 1;
                        --n;
                    }
                    if (nArray[3] < this.theMech.locMaxArmour[3] && n > 0) {
                        nArray[3] = nArray[3] + 1;
                        --n;
                    }
                }
                case 4: 
                case 5: {
                    if (nArray[2] >= this.theMech.locMaxArmour[2] || n <= 0) break;
                    nArray[2] = nArray[2] + 1;
                    --n;
                }
            }
            ++n2;
        }
        nArray[10] = (int)(0.3 * (double)nArray[3]);
        nArray[3] = nArray[3] - nArray[10];
        nArray[8] = (int)(0.3 * (double)nArray[1]);
        nArray[1] = nArray[1] - nArray[8];
        nArray[9] = (int)(0.3 * (double)nArray[2]);
        nArray[2] = nArray[2] - nArray[9];
        this.armCTSpin.setValue(nArray[2]);
        this.armRTSpin.setValue(nArray[3]);
        this.armLTSpin.setValue(nArray[1]);
        this.armRASpin.setValue(nArray[5]);
        this.armRLSpin.setValue(nArray[7]);
        this.armLLSpin.setValue(nArray[6]);
        this.armLASpin.setValue(nArray[4]);
        this.armHSpin.setValue(nArray[0]);
        this.armRearLTSpin.setValue(nArray[8]);
        this.armRearRTSpin.setValue(nArray[10]);
        this.armRearCTSpin.setValue(nArray[9]);
    }

    public void pressedHsSpin() {
        int n = 3;
        int n2 = (Integer)this.hsSpin.getValue();
        if (this.theMech.isClan) {
            n = 2;
        }
        if (!this.theMech.doubleHS) {
            n = 1;
        }
        if (this.theMech.totalEmptyCrits() >= n || n2 <= this.theMech.calcFreeHS() || n2 < this.theMech.sinks) {
            this.theMech.sinks = n2;
        } else {
            this.statusLabel.setText(this.statusLabel.getText() + "Not enough space for heat sinks. Quantity reduced.  --  ");
            this.hsSpin.setValue(this.theMech.sinks);
        }
        this.updateForm();
    }

    private void pressedArmHSpin() {
        this.theMech.locArmour[0] = (Integer)this.armHSpin.getValue();
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armHSpin.setValue((Integer)this.armHSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmLTSpin() {
        int n = (Integer)this.armLTSpin.getValue();
        int n2 = (Integer)this.armRearLTSpin.getValue();
        this.theMech.locArmour[1] = n;
        if (n + n2 > this.theMech.locMaxArmour[1]) {
            this.armRearLTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armLTSpin.setValue((Integer)this.armLTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmCTSpin() {
        int n = (Integer)this.armCTSpin.getValue();
        int n2 = (Integer)this.armRearCTSpin.getValue();
        this.theMech.locArmour[2] = n;
        if (n + n2 > this.theMech.locMaxArmour[2]) {
            this.armRearCTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armCTSpin.setValue((Integer)this.armCTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRTSpin() {
        int n = (Integer)this.armRTSpin.getValue();
        int n2 = (Integer)this.armRearRTSpin.getValue();
        this.theMech.locArmour[3] = n;
        if (n + n2 > this.theMech.locMaxArmour[3]) {
            this.armRearRTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRTSpin.setValue((Integer)this.armRTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRearLTSpin() {
        int n = (Integer)this.armRearLTSpin.getValue();
        int n2 = (Integer)this.armLTSpin.getValue();
        this.theMech.locArmour[8] = n;
        if (n + n2 > this.theMech.locMaxArmour[1]) {
            this.armLTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRearLTSpin.setValue((Integer)this.armRearLTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRearCTSpin() {
        int n = (Integer)this.armRearCTSpin.getValue();
        int n2 = (Integer)this.armCTSpin.getValue();
        this.theMech.locArmour[9] = n;
        if (n + n2 > this.theMech.locMaxArmour[2]) {
            this.armCTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRearCTSpin.setValue((Integer)this.armRearCTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRearRTSpin() {
        int n = (Integer)this.armRearRTSpin.getValue();
        int n2 = (Integer)this.armRTSpin.getValue();
        this.theMech.locArmour[10] = n;
        if (n + n2 > this.theMech.locMaxArmour[3]) {
            this.armRTSpin.setValue(n2 - 1);
        }
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRearRTSpin.setValue((Integer)this.armRearRTSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmLASpin() {
        this.theMech.locArmour[4] = (Integer)this.armLASpin.getValue();
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armLASpin.setValue((Integer)this.armLASpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRASpin() {
        this.theMech.locArmour[5] = (Integer)this.armRASpin.getValue();
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRASpin.setValue((Integer)this.armRASpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmLLSpin() {
        this.theMech.locArmour[6] = (Integer)this.armLLSpin.getValue();
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armLLSpin.setValue((Integer)this.armLLSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedArmRLSpin() {
        this.theMech.locArmour[7] = (Integer)this.armRLSpin.getValue();
        if (this.theMech.calcArmourPts() > this.theMech.maxArmour) {
            this.armRLSpin.setValue((Integer)this.armRLSpin.getValue() - 1);
        }
        this.updateForm();
    }

    private void pressedSave() {
        boolean bl = true;
        String string = "";
        String string2 = this.nameField.getText() + " " + this.variantField.getText();
        try {
            int n;
            int n2;
            int n3;
            this.sheetPanel.saveImg(string2);
            MyTextWriter myTextWriter = new MyTextWriter(string2 + ".mtf");
            myTextWriter.addLine("Version:1.0");
            myTextWriter.addLine(this.nameField.getText());
            myTextWriter.addLine(this.variantField.getText());
            myTextWriter.addLine();
            string = this.theMech.isFourLegger ? "Config:Quad" : "Config:Biped";
            if (this.theMech.isOmni) {
                string = string + " Omnimech";
            }
            myTextWriter.addLine(string);
            if (this.theMech.isClan) {
                myTextWriter.addLine("TechBase:Clan");
            } else {
                myTextWriter.addLine("TechBase:Inner Sphere");
            }
            myTextWriter.addLine("Era:" + this.erabox.getText());
            myTextWriter.addLine("Rules Level:" + this.theMech.calcMtfRulesLevel());
            myTextWriter.addLine();
            myTextWriter.addLine("Mass:" + (int)this.theMech.tonnage);
            string = "Fusion";
            if (!this.theMech.engineType.equals("Standard")) {
                string = this.theMech.engineType;
            }
            myTextWriter.addLine("Engine:" + (int)((double)this.theMech.walk * this.theMech.tonnage) + " " + string + " Engine");
            if (this.theMech.endo) {
                myTextWriter.addLine("Structure:Endo Steel");
            } else {
                myTextWriter.addLine("Structure:Standard");
            }
            if (this.theMech.tsm) {
                myTextWriter.addLine("Myomer:Triple-Strength");
            } else {
                myTextWriter.addLine("Myomer:Standard");
            }
            if (this.theMech.cockpit.equals("Small")) {
                myTextWriter.addLine("Cockpit:Small Cockpit");
            }
            if (!this.theMech.gyro.equals("Standard")) {
                myTextWriter.addLine("Gyro:" + this.theMech.gyro + " Gyro");
            }
            myTextWriter.addLine();
            if (this.theMech.doubleHS) {
                myTextWriter.addLine("Heat Sinks:" + this.theMech.sinks + " Double");
            } else {
                myTextWriter.addLine("Heat Sinks:" + this.theMech.sinks + " Single");
            }
            myTextWriter.addLine("Walk MP:" + this.theMech.walk);
            myTextWriter.addLine("Jump MP:" + this.theMech.calcJump());
            myTextWriter.addLine();
            myTextWriter.addLine("Armor:" + this.theMech.armour);
            myTextWriter.addLine("LA Armor:" + this.theMech.locArmour[4]);
            myTextWriter.addLine("RA Armor:" + this.theMech.locArmour[5]);
            myTextWriter.addLine("LT Armor:" + this.theMech.locArmour[1]);
            myTextWriter.addLine("RT Armor:" + this.theMech.locArmour[3]);
            myTextWriter.addLine("CT Armor:" + this.theMech.locArmour[2]);
            myTextWriter.addLine("HD Armor:" + this.theMech.locArmour[0]);
            myTextWriter.addLine("LL Armor:" + this.theMech.locArmour[6]);
            myTextWriter.addLine("RL Armor:" + this.theMech.locArmour[7]);
            myTextWriter.addLine("RTL Armor:" + this.theMech.locArmour[8]);
            myTextWriter.addLine("RTR Armor:" + this.theMech.locArmour[10]);
            myTextWriter.addLine("RTC Armor:" + this.theMech.locArmour[9]);
            myTextWriter.addLine();
            ArrayList<String> arrayList = this.getMtfWeaps();
            myTextWriter.addLine("Weapons:" + arrayList.size());
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                myTextWriter.addLine(arrayList.get(n3));
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Left Arm:");
            for (n3 = 0; n3 < 12; ++n3) {
                if (n3 < this.theMech.locCrits[4] && this.theMech.locs[4].crits[n3] != null) {
                    string = this.theMech.locs[4].crits[n3].getMtfID();
                    if (this.theMech.locs[4].crits[n3].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Right Arm:");
            for (n3 = 0; n3 < 12; ++n3) {
                if (n3 < this.theMech.locCrits[5] && this.theMech.locs[5].crits[n3] != null) {
                    string = this.theMech.locs[5].crits[n3].getMtfID();
                    if (this.theMech.locs[5].crits[n3].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Left Torso:");
            for (n3 = 0; n3 < 12; ++n3) {
                if (n3 < this.theMech.locCrits[1] && this.theMech.locs[1].crits[n3] != null) {
                    string = this.theMech.locs[1].crits[n3].getMtfID();
                    if (this.theMech.locs[1].crits[n3].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Right Torso:");
            for (n3 = 0; n3 < 12; ++n3) {
                if (n3 < this.theMech.locCrits[3] && this.theMech.locs[3].crits[n3] != null) {
                    string = this.theMech.locs[3].crits[n3].getMtfID();
                    if (this.theMech.locs[3].crits[n3].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Center Torso:");
            for (n3 = 0; n3 < 12; ++n3) {
                if (n3 < this.theMech.locCrits[2] && this.theMech.locs[2].crits[n3] != null) {
                    string = this.theMech.locs[2].crits[n3].getMtfID();
                    if (this.theMech.locs[2].crits[n3].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Head:");
            int[] nArray = new int[]{0, 1, 2, 5, 3, 4, 7, 7, 7, 7, 7, 7};
            for (n2 = 0; n2 < 12; ++n2) {
                int n4 = n2;
                if (this.theMech.cockpit.equals("Standard")) {
                    n4 = nArray[n2];
                }
                if (n2 < this.theMech.locCrits[0] && this.theMech.locs[0].crits[n4] != null) {
                    string = this.theMech.locs[0].crits[n4].getMtfID();
                    if (this.theMech.locs[0].crits[n4].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Left Leg:");
            for (n2 = 0; n2 < 12; ++n2) {
                if (n2 < this.theMech.locCrits[6] && this.theMech.locs[6].crits[n2] != null) {
                    string = this.theMech.locs[6].crits[n2].getMtfID();
                    if (this.theMech.locs[6].crits[n2].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.addLine("Right Leg:");
            for (n2 = 0; n2 < 12; ++n2) {
                if (n2 < this.theMech.locCrits[7] && this.theMech.locs[7].crits[n2] != null) {
                    string = this.theMech.locs[7].crits[n2].getMtfID();
                    if (this.theMech.locs[7].crits[n2].rearFacing) {
                        string = string + " (R)";
                    }
                    myTextWriter.addLine(string);
                    continue;
                }
                myTextWriter.addLine("-Empty-");
            }
            myTextWriter.addLine();
            myTextWriter.save();
            myTextWriter = new MyTextWriter(string2 + ".txt");
            myTextWriter.addLine("===============================================================================================");
            string = this.theMech.isOmni ? "Omni " : "";
            String string3 = String.format("%-40s", this.theMech.name + " " + this.theMech.variant);
            string3 = this.theMech.isClan ? string3 + "Clan" : string3 + "IS";
            string3 = string3 + "  " + (int)this.theMech.tonnage + "t  " + string;
            string3 = this.theMech.isFourLegger ? string3 + "  Quad" : string3 + "  Biped";
            string3 = String.format("%-67s", string3) + "BV2: " + this.theMech.calcBV();
            myTextWriter.addLine(string3);
            string = "MP: " + this.theMech.walk + "/" + this.theMech.run + "/" + this.theMech.calcJump() + "  ";
            String[] stringArray = new String[]{"CLMASC", "ISMASC"};
            if (this.theMech.countItem(stringArray) > 0) {
                string = string + "MASC ";
            }
            if (this.theMech.tsm) {
                string = string + "TSM";
            }
            string3 = String.format("%-20s", string);
            string3 = this.theMech.doubleHS ? string3 + String.format("%-20s", this.theMech.sinks + " Double HS") : string3 + String.format("%-20s", this.theMech.sinks + " Single HS");
            if (this.theMech.endo) {
                string3 = string3 + "Endo Steel";
            }
            string3 = String.format("%-67s", string3) + "C-Bills: " + this.theMech.getCostStr(this.theMech.calcCost());
            myTextWriter.addLine(string3);
            string3 = String.format("%-20s", "Engine: " + this.theMech.engineType);
            string3 = string3 + String.format("%-20s", "Gyro: " + this.theMech.gyro);
            string3 = string3 + String.format("%-27s", "Cockpit: " + this.theMech.cockpit);
            if (this.theMech.leftArm) {
                string3 = string3 + "LLAA ";
            }
            if (this.theMech.leftHand) {
                string3 = string3 + "LHA  ";
            }
            if (this.theMech.rightArm) {
                string3 = string3 + "RLAA ";
            }
            if (this.theMech.rightHand) {
                string3 = string3 + "RHA ";
            }
            myTextWriter.addLine(string3);
            myTextWriter.addLine("-----------------------------------------------------------------------------------------------");
            string3 = String.format("%-25s", this.theMech.armour + ": ");
            string3 = string3 + String.format("%-12s", "LA: " + this.theMech.locArmour[4]);
            string3 = string3 + String.format("%-12s", "H:  " + this.theMech.locArmour[0]);
            string3 = string3 + String.format("%-18s", "RA: " + this.theMech.locArmour[5]);
            string3 = string3 + "Total: " + this.theMech.armourPts;
            myTextWriter.addLine(string3);
            string3 = String.format("%-25s", " ");
            string3 = string3 + String.format("%-12s", "LT: " + this.theMech.locArmour[1] + " /" + this.theMech.locArmour[8]);
            string3 = string3 + String.format("%-12s", "CT: " + this.theMech.locArmour[2] + " /" + this.theMech.locArmour[9]);
            string3 = string3 + String.format("%-12s", "RT: " + this.theMech.locArmour[3] + " /" + this.theMech.locArmour[10]);
            myTextWriter.addLine(string3);
            string3 = String.format("%-25s", " ");
            string3 = string3 + String.format("%-24s", "LL: " + this.theMech.locArmour[6]);
            string3 = string3 + String.format("%-12s", "RL: " + this.theMech.locArmour[7]);
            myTextWriter.addLine(string3);
            myTextWriter.addLine("-----------------------------------------------------------------------------------------------");
            ArrayList[] arrayListArray = new ArrayList[8];
            ArrayList[] arrayListArray2 = new ArrayList[8];
            for (n = 0; n < 8; ++n) {
                arrayListArray[n] = new ArrayList();
                arrayListArray2[n] = new ArrayList();
                for (int i = 0; i < this.theMech.locCrits[n]; ++i) {
                    int n5;
                    Mount mount = this.theMech.locs[n].crits[i];
                    if (mount == null || mount.split || mount.size == -1 || !mount.i.showInList && !mount.i.id.contains("Sink") && !mount.i.id.contains("Jump")) continue;
                    String string4 = mount.i.getName();
                    if (mount.rearFacing) {
                        string4 = string4 + " [R]";
                    }
                    if ((n5 = arrayListArray[n].indexOf(string4)) == -1) {
                        arrayListArray[n].add(string4);
                        arrayListArray2[n].add(1);
                        continue;
                    }
                    arrayListArray2[n].set(n5, (Integer)arrayListArray2[n].get(n5) + 1);
                }
            }
            string3 = "Crits:    " + String.format("%-30s", "LA ") + String.format("%-30s", "H ") + String.format("%-30s", "RA ");
            myTextWriter.addLine(string3);
            for (n = 0; n < Math.max(Math.max(arrayListArray[4].size(), arrayListArray[0].size()), arrayListArray[5].size()); ++n) {
                string3 = "          ";
                string = arrayListArray[4].size() > n ? " " + arrayListArray2[4].get(n) + " " + (String)arrayListArray[4].get(n) : " ";
                string3 = string3 + String.format("%-30s", string);
                string = arrayListArray[0].size() > n ? " " + arrayListArray2[0].get(n) + " " + (String)arrayListArray[0].get(n) : " ";
                string3 = string3 + String.format("%-30s", string);
                string = arrayListArray[5].size() > n ? " " + arrayListArray2[5].get(n) + " " + (String)arrayListArray[5].get(n) : " ";
                string3 = string3 + string;
                myTextWriter.addLine(string3);
            }
            string3 = "\n          " + String.format("%-30s", "LT ") + String.format("%-30s", "CT ") + String.format("%-30s", "RT ");
            myTextWriter.addLine(string3);
            for (n = 0; n < Math.max(Math.max(arrayListArray[1].size(), arrayListArray[2].size()), arrayListArray[3].size()); ++n) {
                string3 = "          ";
                string = arrayListArray[1].size() > n ? " " + arrayListArray2[1].get(n) + " " + (String)arrayListArray[1].get(n) : " ";
                string3 = string3 + String.format("%-30s", string);
                string = arrayListArray[2].size() > n ? " " + arrayListArray2[2].get(n) + " " + (String)arrayListArray[2].get(n) : " ";
                string3 = string3 + String.format("%-30s", string);
                string = arrayListArray[3].size() > n ? " " + arrayListArray2[3].get(n) + " " + (String)arrayListArray[3].get(n) : " ";
                string3 = string3 + string;
                myTextWriter.addLine(string3);
            }
            string3 = "\n          " + String.format("%-30s", "LL ") + String.format("%-30s", " ") + String.format("%-30s", "RL ");
            myTextWriter.addLine(string3);
            for (n = 0; n < Math.max(arrayListArray[6].size(), arrayListArray[7].size()); ++n) {
                string3 = "          ";
                string = arrayListArray[6].size() > n ? " " + arrayListArray2[6].get(n) + " " + (String)arrayListArray[6].get(n) : " ";
                string3 = string3 + String.format("%-30s", string);
                string3 = string3 + String.format("%-30s", " ");
                string = arrayListArray[7].size() > n ? " " + arrayListArray2[7].get(n) + " " + (String)arrayListArray[7].get(n) : " ";
                string3 = string3 + string;
                myTextWriter.addLine(string3);
            }
            myTextWriter.addLine("======================================================================[QuickMech v0.4]=========");
            myTextWriter.save();
        }
        catch (Exception exception) {
            bl = false;
            this.statusLabel.setText("Save failed! " + exception.getMessage());
        }
        if (bl) {
            this.statusLabel.setText("Saved.  ");
        }
    }

    private ArrayList<String> getMtfWeaps() {
        String[] stringArray = new String[]{"Head", "Left Torso", "Center Torso", "Right Torso", "Left Arm", "Right Arm", "Left Leg", "Right Leg"};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.theMech.locCrits[i]; ++j) {
                if (this.theMech.locs[i].crits[j] == null || this.theMech.locs[i].crits[j].size == -1 || this.theMech.locs[i].crits[j].split || !this.theMech.locs[i].crits[j].i.isWeapon) continue;
                String string = this.theMech.locs[i].crits[j].i.id;
                if (string.startsWith("ART4 ")) {
                    string = string.substring(5);
                }
                arrayList.add(string + ", " + stringArray[i]);
            }
        }
        return arrayList;
    }

    private void pressedLoad() {
        Object object;
        int n;
        String[] stringArray;
        int n2;
        Object object2;
        String[] stringArray2;
        this.adder = new Adders(this, this.theMech);
        MyTextReader myTextReader = null;
        MyTextLine myTextLine = null;
        this.statusLabel.setText("Loading, please wait...");
        this.saveLabel.setText("Loading, please wait...");
        String string = "Loading: ";
        try {
            stringArray2 = new JFileChooser(this.loadPath);
            stringArray2.addChoosableFileFilter(new MyFilter());
            boolean bl = true;
            if (stringArray2.showOpenDialog(this.mainPanel) == 0) {
                bl = false;
                File file = stringArray2.getSelectedFile();
                String string2 = file.getAbsolutePath();
                this.loadPath = file.getParentFile();
                if (string2.contains(".mtf") || string2.contains(".MTF")) {
                    myTextReader = new MyTextReader(string2);
                } else {
                    System.out.println("Invalid file chosen.  ");
                    this.statusLabel.setText("Invalid file chosen.  ");
                    this.saveLabel.setText("Invalid file chosen.  ");
                    bl = true;
                }
                System.out.println("@@@ Loading " + string2);
            }
            this.statusLabel.setText("");
            this.saveLabel.setText("");
            if (bl) {
                return;
            }
            this.theMech.clear();
            this.tsmBox.setEnabled(false);
            this.clanRadio.setEnabled(true);
            this.statusLabel.setText("Loading...");
            this.saveLabel.setText("Loading...");
            string = string + "Name ";
            String string3 = myTextReader.nextString();
            this.theMech.name = myTextReader.nextString();
            this.nameField.setText(this.theMech.name);
            this.theMech.variant = "";
            myTextLine = myTextReader.nextLine();
            if (!myTextLine.nextToken().startsWith("Config:")) {
                this.theMech.variant = myTextLine.toString();
                myTextLine = myTextReader.nextLine();
            }
            this.variantField.setText(this.theMech.variant);
            string = string + "Legs ";
            string3 = myTextLine.after("Config:");
            if (string3.contains("uad")) {
                this.theMech.isFourLegger = true;
                this.fourLegRadio.setSelected(true);
                this.sheetPanel.changeImage("fourLegForm.png", "fourLegFormLocs");
                this.leftArmBox.setEnabled(false);
                this.leftHandBox.setEnabled(false);
                this.rightArmBox.setEnabled(false);
                this.rightHandBox.setEnabled(false);
            } else {
                this.theMech.isFourLegger = false;
                this.twoLegRadio.setSelected(true);
                this.sheetPanel.changeImage("twoLegForm.png", "twoLegFormLocs");
                this.leftArmBox.setEnabled(true);
                this.leftHandBox.setEnabled(true);
                this.rightArmBox.setEnabled(true);
                this.rightHandBox.setEnabled(true);
            }
            if (string3.contains("mni")) {
                this.theMech.isOmni = true;
                this.omniBox.setSelected(true);
            } else {
                this.theMech.isOmni = false;
                this.omniBox.setSelected(false);
            }
            string = string + "Tech ";
            string3 = myTextReader.nextLine().after("TechBase:");
            if (string3.contains("lan")) {
                this.theMech.isClan = true;
                this.clanRadio.setSelected(true);
            } else {
                this.theMech.isClan = false;
                this.isRadio.setSelected(true);
            }
            string = string + "Era ";
            string3 = myTextReader.nextLine().after("Era:");
            int n3 = Integer.parseInt(string3);
            if (n3 > this.eraYears[3][1]) {
                n3 = this.eraYears[3][1];
            }
            if (n3 < this.eraYears[3][0]) {
                n3 = this.eraYears[3][0];
            }
            this.eraCombo.setSelectedIndex(3);
            this.theMech.era = 3;
            this.erabox.setText(n3 + "");
            string = string + "Combos/Trees ";
            this.isEngines = this.eraIsEngines[this.theMech.era];
            this.clanEngines = this.eraClanEngines[this.theMech.era];
            this.isGyros = this.eraIsGyros[this.theMech.era];
            this.clanGyros = this.eraClanGyros[this.theMech.era];
            this.isCockpits = this.eraIsCockpits[this.theMech.era];
            this.clanCockpits = this.eraClanCockpits[this.theMech.era];
            this.isArmours = this.eraIsArmours[this.theMech.era];
            this.clanArmours = this.eraClanArmours[this.theMech.era];
            if (this.theMech.isClan) {
                this.updateTrees("clanWeapons", "clanAmmo");
                this.replaceComboItems(this.engineCombo, this.clanEngines);
                this.replaceComboItems(this.gyroCombo, this.clanGyros);
                this.replaceComboItems(this.cockpitCombo, this.clanCockpits);
                this.replaceComboItems(this.armourCombo, this.clanArmours);
            } else {
                if (this.theMech.era == 0 || this.theMech.era == 3) {
                    this.tsmBox.setEnabled(true);
                }
                this.updateTrees("isWeapons", "isAmmo");
                this.replaceComboItems(this.engineCombo, this.isEngines);
                this.replaceComboItems(this.gyroCombo, this.isGyros);
                this.replaceComboItems(this.cockpitCombo, this.isCockpits);
                this.replaceComboItems(this.armourCombo, this.isArmours);
            }
            string3 = myTextReader.nextString();
            if (string3.startsWith("Source")) {
                myTextReader.nextString();
            }
            this.theMech.mtfRulesLevel = 1;
            string = string + "Tons ";
            string3 = myTextReader.nextLine().after("Mass:");
            this.theMech.tonnage = Integer.parseInt(string3);
            this.tonnageCombo.setSelectedIndex((int)(this.theMech.tonnage - 20.0) / 5);
            if (!this.theMech.isFourLegger) {
                this.leftArmBox.setSelected(false);
                this.theMech.leftArm = false;
                this.leftHandBox.setSelected(false);
                this.theMech.leftHand = false;
                this.rightArmBox.setSelected(false);
                this.theMech.rightArm = false;
                this.rightHandBox.setSelected(false);
                this.theMech.rightHand = false;
            }
            string = string + "Engine ";
            string3 = myTextReader.nextString();
            if (string3.contains("XL")) {
                this.theMech.engineType = "XL";
                if (this.theMech.isClan) {
                    this.engineCombo.setSelectedIndex(1);
                } else {
                    this.engineCombo.setSelectedIndex(3);
                }
            } else if (string3.contains("ompact")) {
                this.theMech.engineType = "XL";
                this.engineCombo.setSelectedIndex(1);
            } else if (string3.contains("ight")) {
                this.theMech.engineType = "Light";
                this.engineCombo.setSelectedIndex(2);
            } else {
                this.theMech.engineType = "Standard";
                this.engineCombo.setSelectedIndex(0);
            }
            string3 = myTextReader.nextLine().after("Structure:");
            if (string3.contains("ndo")) {
                this.theMech.endo = true;
                this.endoRadio.setSelected(true);
            } else {
                this.theMech.endo = false;
                this.standardStructRadio.setSelected(true);
            }
            string = string + "TSM ";
            string3 = myTextReader.nextLine().after("Myomer:");
            if (string3.contains("riple") || string3.contains("TSM")) {
                this.tsmBox.setSelected(true);
                this.theMech.tsm = true;
            } else {
                this.tsmBox.setSelected(false);
                this.theMech.tsm = false;
            }
            string = string + "Cockpit ";
            this.theMech.cockpit = "Standard";
            this.cockpitCombo.setSelectedIndex(0);
            myTextLine = myTextReader.nextLine();
            string3 = myTextLine.toString();
            if (string3.startsWith("Cockpit:")) {
                if (!this.theMech.isClan && string3.contains("mall")) {
                    this.theMech.cockpit = "Small";
                    this.cockpitCombo.setSelectedIndex(1);
                }
                myTextLine = myTextReader.nextLine();
                string3 = myTextLine.toString();
            }
            string = string + "Gyro ";
            this.theMech.gyro = "Standard";
            this.gyroCombo.setSelectedIndex(0);
            if (string3.startsWith("Gyro:")) {
                if (string3.contains("ompact")) {
                    this.theMech.gyro = "Compact";
                    this.gyroCombo.setSelectedIndex(1);
                } else if (string3.contains("eavy")) {
                    this.theMech.gyro = "Heavy-Duty";
                    this.gyroCombo.setSelectedIndex(2);
                } else if (string3.contains("XL")) {
                    this.theMech.gyro = "XL";
                    this.gyroCombo.setSelectedIndex(3);
                }
                myTextLine = myTextReader.nextLine();
                string3 = myTextLine.toString();
            }
            string = string + "HS ";
            string3 = myTextLine.after("Heat Sinks:");
            myTextLine = new MyTextLine(string3);
            this.theMech.sinks = Integer.parseInt(myTextLine.nextToken());
            if (!myTextLine.nextToken().contains("ouble")) {
                this.theMech.doubleHS = false;
                this.stdHSRadio.setSelected(true);
            } else {
                this.theMech.doubleHS = true;
                this.dblHSRadio.setSelected(true);
            }
            string = string + "Walk ";
            myTextLine = myTextReader.nextLine();
            if (myTextLine.nextToken().equals("Base")) {
                myTextLine = myTextReader.nextLine();
            }
            this.theMech.walk = Integer.parseInt(myTextLine.after("Walk MP:"));
            this.theMech.run = (int)Math.ceil((double)this.theMech.walk * 1.5);
            this.walksCombo.setSelectedIndex(this.theMech.walk - 1);
            myTextReader.nextLine();
            string = string + "Armour ";
            string3 = myTextReader.nextLine().after("Armor:");
            this.theMech.armour = "Standard";
            this.armourCombo.setSelectedIndex(0);
            if (string3.contains("tealth")) {
                this.theMech.armour = "Stealth";
                this.armourCombo.setSelectedIndex(1);
            } else if (string3.contains("eavy")) {
                this.theMech.armour = "Heavy Ferro-Fibrous";
                this.armourCombo.setSelectedIndex(4);
            } else if (string3.contains("ight")) {
                this.theMech.armour = "Light Ferro-Fibrous";
                this.armourCombo.setSelectedIndex(2);
            } else if (string3.contains("erro")) {
                if (this.theMech.isClan) {
                    this.theMech.armour = "Ferro-Fibrous";
                    this.armourCombo.setSelectedIndex(1);
                } else {
                    this.theMech.armour = "Ferro-Fibrous";
                    this.armourCombo.setSelectedIndex(3);
                }
            }
            string = string + "AmrPoints ";
            this.theMech.locArmour[4] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[5] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[1] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[3] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[2] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[0] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[6] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[7] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[8] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[10] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.theMech.locArmour[9] = Integer.parseInt(myTextReader.nextLine().after("Armor:"));
            this.armHSpin.setValue(this.theMech.locArmour[0]);
            this.armLASpin.setValue(this.theMech.locArmour[4]);
            this.armRASpin.setValue(this.theMech.locArmour[5]);
            this.armRTSpin.setValue(this.theMech.locArmour[3]);
            this.armLTSpin.setValue(this.theMech.locArmour[1]);
            this.armCTSpin.setValue(this.theMech.locArmour[2]);
            this.armRearCTSpin.setValue(this.theMech.locArmour[9]);
            this.armRearLTSpin.setValue(this.theMech.locArmour[8]);
            this.armRearRTSpin.setValue(this.theMech.locArmour[10]);
            this.armLLSpin.setValue(this.theMech.locArmour[6]);
            this.armRLSpin.setValue(this.theMech.locArmour[7]);
            int n4 = Integer.parseInt(myTextReader.nextLine().after("Weapons:"));
            for (int i = 0; i < n4; ++i) {
                myTextReader.nextString();
            }
            this.theMech.locs[0] = new Loc(this.theMech.locCrits[0], this.theMech);
            this.theMech.locs[1] = new Loc(this.theMech.locCrits[1], this.theMech);
            this.theMech.locs[2] = new Loc(this.theMech.locCrits[2], this.theMech);
            this.theMech.locs[3] = new Loc(this.theMech.locCrits[3], this.theMech);
            this.theMech.locs[4] = new Loc(this.theMech.locCrits[4], this.theMech);
            this.theMech.locs[5] = new Loc(this.theMech.locCrits[5], this.theMech);
            this.theMech.locs[6] = new Loc(this.theMech.locCrits[6], this.theMech);
            this.theMech.locs[7] = new Loc(this.theMech.locCrits[7], this.theMech);
            this.theMech.applyCritsLev0(true);
            string = string + "LA ";
            myTextReader.nextLine();
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            for (n2 = 1; n2 < 13; ++n2) {
                object2 = string3;
                string3 = myTextReader.nextString();
                if (string3.equals("Hand Actuator")) {
                    this.theMech.leftHand = true;
                    this.leftHandBox.setSelected(true);
                }
                if (string3.equals("Lower Arm Actuator")) {
                    this.theMech.leftArm = true;
                    this.leftArmBox.setSelected(true);
                }
                if (!((String)object2).equals(string3)) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 4);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "RA ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            for (n2 = 1; n2 < 13; ++n2) {
                object2 = string3;
                string3 = myTextReader.nextString();
                if (string3.equals("Hand Actuator")) {
                    this.theMech.rightHand = true;
                    this.rightHandBox.setSelected(true);
                }
                if (string3.equals("Lower Arm Actuator")) {
                    this.theMech.rightArm = true;
                    this.rightArmBox.setSelected(true);
                }
                if (!((String)object2).equals(string3)) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 5);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "LT ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!string3.startsWith("Right Torso")) {
                object2 = string3;
                if (!((String)object2).equals(string3 = myTextReader.nextString())) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 1);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "RT ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!string3.startsWith("Center Torso")) {
                object2 = string3;
                if (!((String)object2).equals(string3 = myTextReader.nextString())) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 3);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "CT ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!string3.startsWith("Head")) {
                object2 = string3;
                if (!((String)object2).equals(string3 = myTextReader.nextString())) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 2);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "H ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!string3.startsWith("Left Leg") && !string3.startsWith("Rear Left Leg")) {
                object2 = string3;
                if (!((String)object2).equals(string3 = myTextReader.nextString())) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 0);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "LL ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!string3.startsWith("Right Leg") && !string3.startsWith("Rear Right Leg")) {
                object2 = string3;
                if (!((String)object2).equals(string3 = myTextReader.nextString())) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 6);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            string = string + "RL ";
            n4 = 1;
            object2 = "gtdswwngsrd";
            string3 = myTextReader.nextString();
            while (!myTextReader.closed) {
                object2 = string3;
                string3 = myTextReader.nextString();
                if (string3 == null) break;
                if (!((String)object2).equals(string3)) {
                    if (!((String)object2).equals("-Empty-")) {
                        this.loadMount((String)object2, n4, 7);
                    }
                    n4 = 1;
                    continue;
                }
                ++n4;
            }
            myTextReader.br.close();
        }
        catch (Exception exception) {
            this.clearTheMech();
            System.out.println("@@@ Load failed. " + string + " ---" + exception.getMessage());
            this.statusLabel.setText("Load failed. " + exception.getMessage());
            this.saveLabel.setText("Load failed. " + exception.getMessage());
            this.nameField.setText("error");
            this.variantField.setText("error");
        }
        stringArray2 = new String[]{"CLLRM5", "CLLRM10", "CLLRM15", "CLLRM20", "CLSRM2", "CLSRM4", "CLSRM6", "CLLRM5 (OS)", "CLLRM10 (OS)", "CLLRM15 (OS)", "CLLRM20 (OS)", "CLSRM2 (OS)", "CLSRM4 (OS)", "CLSRM6 (OS)"};
        String[] stringArray3 = stringArray = new String[]{"LRM 5", "LRM 10", "LRM 15", "LRM 20", "ISMML3", "ISMML5", "ISMML7", "ISMML9", "SRM 2", "SRM 4", "SRM 6", "LRM 5 (OS)", "LRM 10 (OS)", "LRM 15 (OS)", "LRM 20 (OS)", "ISSRM2OS", "ISSRM4OS", "ISSRM6OS"};
        String string4 = "ISArtemisIV";
        if (this.theMech.isClan) {
            string4 = "CLArtemisIV";
            stringArray3 = stringArray2;
        }
        object2 = new int[8];
        for (n2 = 0; n2 < 8; ++n2) {
            object2[n2] = this.theMech.locs[n2].count(string4);
            for (n = 0; n < object2[n2]; ++n) {
                this.theMech.locs[n2].slide(this.theMech.locs[n2].getLast(string4));
            }
            for (n = 0; n < object2[n2]; ++n) {
                int n5 = this.theMech.locs[n2].getLastArray(stringArray3);
                if (n5 == -1) continue;
                object = this.theMech.locs[n2].crits[n5].getHead().i.id;
                this.theMech.locs[n2].slide(n5);
                object = "ART4 " + (String)object;
                Item item = this.findItem((String)object, false);
                this.adder.add(item, n2, -1, -1);
            }
        }
        String[] stringArray4 = new String[]{"ISLBXAC20", "Autocannon/20", "ISUltraAC20", "CLLBXAC20", "CLUltraAC20", "ISHeavyGaussRifle"};
        for (n = 0; n < stringArray4.length; ++n) {
            String string5 = stringArray4[n];
            object = this.findItem(string5, false);
            if (object == null) continue;
            int n6 = this.theMech.getCrit.get((Item)object);
            int[] nArray = this.countAndRemoveWeapCrits(string5);
            if (nArray[4] >= n6) {
                this.adder.add((Item)object, 4, -1, -1);
                nArray[4] = nArray[4] - n6;
            }
            if (nArray[4] > 0) {
                this.adder.add((Item)object, 4, nArray[4], n6 - nArray[4]);
                nArray[1] = nArray[1] - (n6 - nArray[4]);
                nArray[4] = 0;
            }
            if (nArray[6] > 0) {
                this.adder.add((Item)object, 6, nArray[6], n6 - nArray[6]);
                nArray[1] = nArray[1] - (n6 - nArray[6]);
                nArray[6] = 0;
            }
            if (nArray[1] >= n6) {
                this.adder.add((Item)object, 1, -1, -1);
                nArray[1] = nArray[1] - n6;
            }
            if (nArray[1] > 0) {
                this.adder.add((Item)object, 1, nArray[1], n6 - nArray[1]);
                nArray[2] = nArray[2] - (n6 - nArray[1]);
                nArray[1] = 0;
            }
            if (nArray[5] >= n6) {
                this.adder.add((Item)object, 5, -1, -1);
                nArray[5] = nArray[5] - n6;
            }
            if (nArray[5] > 0) {
                this.adder.add((Item)object, 5, nArray[5], n6 - nArray[5]);
                nArray[3] = nArray[3] - (n6 - nArray[5]);
                nArray[5] = 0;
            }
            if (nArray[7] > 0) {
                this.adder.add((Item)object, 7, nArray[7], n6 - nArray[7]);
                nArray[3] = nArray[3] - (n6 - nArray[7]);
                nArray[7] = 0;
            }
            if (nArray[3] >= n6) {
                this.adder.add((Item)object, 3, -1, -1);
                nArray[3] = nArray[3] - n6;
            }
            if (nArray[3] <= 0) continue;
            this.adder.add((Item)object, 3, nArray[3], n6 - nArray[3]);
            nArray[2] = nArray[2] - (n6 - nArray[3]);
            nArray[3] = 0;
        }
        this.theMech.jump = this.theMech.calcJump();
        this.saveLabel.setText("");
        this.updateForm();
        if (this.theMech.isClan || this.theMech.countItem("ISMASC") > 0) {
            this.tsmBox.setEnabled(false);
        } else {
            this.tsmBox.setEnabled(false);
        }
    }

    private int[] countAndRemoveWeapCrits(String string) {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        for (int i = 0; i < 8; ++i) {
            for (int j = this.theMech.locCrits[i] - 1; j >= 0; --j) {
                Mount mount = this.theMech.locs[i].crits[j];
                if (mount == null || !mount.getHead().i.id.equals(string)) continue;
                int n = i;
                nArray[n] = nArray[n] + 1;
                if (mount.size == -1) continue;
                this.theMech.locs[i].slide(j);
            }
        }
        return nArray;
    }

    private void loadMount(String string, int n, int n2) {
        Item item;
        boolean bl = false;
        if (string.endsWith(" (R)")) {
            bl = true;
            string = string.substring(0, string.length() - 4);
        }
        if ((item = this.findItem(string, true)) != null) {
            int n3 = this.theMech.getCrit.get(item);
            if (string.contains("argeting")) {
                n3 = n;
            }
            while (n > 0) {
                int n4 = Math.min(n, n3);
                n -= n4;
                Color color = this.theMech.weaponCol;
                if (!item.isWeapon) {
                    color = this.theMech.nonWeapCol;
                }
                if (item.isAmmo) {
                    color = this.theMech.ammoCol;
                }
                if (!item.showInList) {
                    color = this.theMech.movableCol;
                }
                Mount mount = new Mount(item, n4, color);
                mount.rearFacing = bl;
                this.theMech.locs[n2].push(mount);
            }
        }
    }

    public Item findItem(String string, boolean bl) {
        int n;
        Item item = null;
        ArrayList<String> arrayList = null;
        Item item2 = null;
        if (string.endsWith("plit)")) {
            string = string.substring(0, string.length() - 8);
        }
        for (int i = 0; i < this.weapsTree.itemList.size(); ++i) {
            item = this.weapsTree.itemList.get(i);
            if (!item.id.equals(string)) continue;
            return item;
        }
        String string2 = string.replaceAll(" ", "");
        for (n = 0; n < this.weapsTree.itemList.size(); ++n) {
            item = this.weapsTree.itemList.get(n);
            if (!item.id.equals(string2)) continue;
            return item;
        }
        if (bl) {
            for (n = 0; n < this.mtfNames.size(); ++n) {
                arrayList = this.mtfNames.get(n);
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!string.equals(arrayList.get(i))) continue;
                    i = arrayList.size();
                    for (int j = 0; j < arrayList.size(); ++j) {
                        item2 = this.findItem(arrayList.get(j), false);
                        if (item2 == null) continue;
                        return item2;
                    }
                }
            }
        }
        return null;
    }

    private void pressedAbout() {
        JFrame jFrame = new JFrame("About QuickMech");
        try {
            jFrame.setIconImage(ImageIO.read(new File("icon.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        jFrame.setDefaultCloseOperation(2);
        Container container = jFrame.getContentPane();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(this.backCol);
        jTabbedPane.setPreferredSize(new Dimension(1000, 500));
        container.add(jTabbedPane);
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextArea = new JTextArea(this.loadString("docs/How"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("How", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/What"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("What", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/Why"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("Why", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/FAQ"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("FAQ", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/Bugs"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("Reporting Bugs", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/Issues"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("Issues", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/FurtherReading"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("Further Reading", jScrollPane);
        jScrollPane = new JScrollPane();
        jTextArea = new JTextArea(this.loadString("docs/VersionHistory"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jScrollPane.setViewportView(jTextArea);
        jTabbedPane.addTab("Version History", jScrollPane);
        jFrame.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        jFrame.setLocation((int)(dimension.getWidth() - (double)jFrame.getWidth()) / 2, (int)(dimension.getHeight() - (double)jFrame.getHeight()) / 2);
        jFrame.setVisible(true);
    }

    private void pressedHide() {
        if (this.hiding) {
            this.weapsTreeScrollPane.setBounds(1038, 19, 434, 705);
            this.weapsTreeScrollPane.setViewportView(this.weapsTree);
            this.hiding = false;
            this.hideButton.setText("|");
        } else {
            this.weapsTreeScrollPane.setBounds(1038, 19, 434, 835);
            this.weapsTreeScrollPane.setViewportView(this.weapsTree);
            this.hiding = true;
            this.hideButton.setText("!");
        }
    }

    private String loadString(String string) {
        MyTextReader myTextReader = new MyTextReader(string);
        String string2 = "";
        while (!myTextReader.closed) {
            String string3 = myTextReader.nextString();
            if (string3 == null) continue;
            string2 = string2 + string3 + "\n";
        }
        return string2.replace("^", "\n");
    }

    private void clearGroup() {
        this.theMech.clear();
        if (this.theMech.sinks != (Integer)this.hsSpin.getValue()) {
            this.hsSpin.setValue(this.theMech.sinks);
        }
        if (this.theMech.armour.equals("Standard") && this.armourCombo.getSelectedIndex() > 0) {
            this.armourCombo.setSelectedIndex(0);
        }
        if (!this.theMech.doubleHS && this.dblHSRadio.isSelected()) {
            this.stdHSRadio.setSelected(true);
        }
        if (!this.theMech.tsm && this.tsmBox.isSelected()) {
            this.tsmBox.setSelected(false);
        }
    }

    private void updateGroup() {
        this.theMech.update();
        if (this.theMech.sinks != (Integer)this.hsSpin.getValue()) {
            this.hsSpin.setValue(this.theMech.sinks);
        }
        if (this.theMech.armour.equals("Standard") && this.armourCombo.getSelectedIndex() > 0) {
            this.armourCombo.setSelectedIndex(0);
        }
        if (!this.theMech.doubleHS && this.dblHSRadio.isSelected()) {
            this.stdHSRadio.setSelected(true);
        }
        if (!this.theMech.tsm && this.tsmBox.isSelected()) {
            this.tsmBox.setSelected(false);
        }
    }

    private void clearTheMech() {
        this.statusLabel.setText("");
        this.clearGroup();
        this.walksCombo.setSelectedIndex(0);
        this.gyroCombo.setSelectedIndex(0);
        this.cockpitCombo.setSelectedIndex(0);
        this.engineCombo.setSelectedIndex(0);
        this.armourCombo.setSelectedIndex(0);
        this.standardStructRadio.setSelected(true);
        this.tsmBox.setSelected(false);
        this.leftArmBox.setSelected(true);
        this.leftHandBox.setSelected(true);
        this.rightArmBox.setSelected(true);
        this.rightHandBox.setSelected(true);
        this.hsSpin.setModel(new SpinnerNumberModel(10, 10, 10 + (int)(this.theMech.tonnage - this.theMech.currWeight), 1));
        this.armHSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[0], 1));
        this.armLTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[1], 1));
        this.armCTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[2], 1));
        this.armRTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[3], 1));
        this.armRearLTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[8], 1));
        this.armRearCTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[9], 1));
        this.armRearRTSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[10], 1));
        this.armLASpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[4], 1));
        this.armRASpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[5], 1));
        this.armLLSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[6], 1));
        this.armRLSpin.setModel(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[7], 1));
        this.armHLabel.setText("/" + this.theMech.locMaxArmour[0] + ") Head");
        this.armLTLabel.setText("/" + this.theMech.locMaxArmour[1] + ") Left Torso");
        this.armCTLabel.setText("/" + this.theMech.locMaxArmour[2] + ") Centre Torso");
        this.armRTLabel.setText("/" + this.theMech.locMaxArmour[3] + ") Right Torso");
        this.armRearLTLabel.setText("/" + this.theMech.locMaxArmour[8] + ") Rear LT");
        this.armRearCTLabel.setText("/" + this.theMech.locMaxArmour[9] + ") Rear CT");
        this.armRearRTLabel.setText("/" + this.theMech.locMaxArmour[10] + ") Rear RT");
        String string = this.theMech.isFourLegger ? "Front Leg" : "Arm";
        this.armLALabel.setText("/" + this.theMech.locMaxArmour[4] + ") Left " + string + "");
        this.armRALabel.setText("/" + this.theMech.locMaxArmour[5] + ") Right " + string + "");
        string = this.theMech.isFourLegger ? "Rear " : "";
        this.armLLLabel.setText("/" + this.theMech.locMaxArmour[6] + ") Left " + string + "Leg");
        this.armRLLabel.setText("/" + this.theMech.locMaxArmour[7] + ") Right " + string + "Leg");
        this.validityChecks();
    }

    private void updateForm() {
        this.statusLabel.setText("");
        this.updateGroup();
        this.armourLabel2.setText("Amour: " + this.theMech.armourTons + "/" + this.theMech.maxArmTons + " tons.  " + this.theMech.armourPts + "/" + this.theMech.maxArmour + " pts.");
        this.validityChecks();
    }

    public void validityChecks() {
        String[] stringArray;
        this.saveBtn.setEnabled(true);
        this.theMech.refreshTargetingComputer();
        this.massLabel.setText(this.theMech.calcCurrWeight() + " / " + this.theMech.tonnage + "  Tons");
        this.critsLabel.setText(this.theMech.totalCrits() - this.theMech.totalEmptyCrits() + " / " + this.theMech.totalCrits() + "  Crits");
        this.saveLabel.setText("");
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < this.theMech.locCrits[i]; ++j) {
                if (this.theMech.locs[i].crits[j] == null || this.theMech.locs[i].crits[j].split || this.theMech.locs[i].crits[j].size == -1 || this.theMech.locs[i].crits[j].i.ammoTypes.size() <= 0) continue;
                String[] stringArray2 = new String[this.theMech.locs[i].crits[j].i.ammoTypes.size()];
                this.theMech.locs[i].crits[j].i.ammoTypes.toArray(stringArray2);
                if (this.theMech.countItem(stringArray2) >= 1) continue;
                this.saveLabel.setText(this.theMech.locs[i].crits[j].i.getName() + " has no ammo mounted on mech.  --  " + this.saveLabel.getText());
                this.saveBtn.setEnabled(false);
            }
        }
        String[] stringArray3 = new String[]{"CLLBXAC2", "CLLBXAC5", "CLLBXAC10", "CLUltraAC2", "CLUltraAC5", "CLUltraAC10", "Autocannon/2", "Autocannon/5", "Autocannon/10", "ISLBXAC2", "ISLBXAC5", "ISLBXAC10", "Light Auto Cannon/2", "Light Auto Cannon/5", "ISRotaryAC2", "ISRotaryAC5", "ISUltraAC2", "ISUltraAC5", "ISUltraAC10", "ISLBXAC20", "Autocannon/20", "ISUltraAC20", "CLLBXAC20", "CLUltraAC20", "ISLightGaussRifle", "ISGaussRifle", "CLAPGaussRifle", "CLGaussRifle", "CLHAG20", "CLHAG30", "CLHAG40", "ISHeavyGaussRifle", "CLERPPC", "ISERPPC", "ISSNPPC", "PPC", "Heavy PPC", "Light PPC"};
        if (!this.theMech.isFourLegger && this.theMech.isOmni && this.theMech.locs[5].count(stringArray3) > 0 && this.theMech.rightHand || !this.theMech.isFourLegger && this.theMech.isOmni && this.theMech.locs[4].count(stringArray3) > 0 && this.theMech.leftHand) {
            this.saveLabel.setText("Biped Omni-mechs may not mount a PPC, AC, or Gauss in an arm with a hand.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.locs[5].count(stringArray = new String[]{"Sword", "Hatchet"}) > 0 && !this.theMech.rightHand || this.theMech.locs[4].count(stringArray) > 0 && !this.theMech.leftHand) {
            this.saveLabel.setText("Sword/hatchet cannot be mounted in an arm without hand.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.locs[5].count(stringArray) > 1 || this.theMech.locs[4].count(stringArray) > 1) {
            this.saveLabel.setText("Maximum one sword/hatchet per arm.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.countItem("Jump_Jet") > 0 && this.theMech.calcJump() > this.theMech.walk) {
            this.saveLabel.setText("Standard Jump Jets mounted must not exceed Walk value.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.countItem("Jump_Jet") == 0 && this.theMech.calcJump() > this.theMech.run) {
            this.saveLabel.setText("Improved Jump Jets mounted must not exceed Run value.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.armour.equals("Stealth") && this.theMech.countItem("ISGuardianECMSuite") < 1) {
            this.saveLabel.setText("Stealth armour must have an ECM suite installed.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        }
        if (this.theMech.currWeight > this.theMech.tonnage) {
            this.massLabel.setForeground(Color.red);
            this.saveLabel.setText("Mech is overweight.  --  " + this.saveLabel.getText());
            this.saveBtn.setEnabled(false);
        } else {
            this.massLabel.setForeground(Color.black);
        }
        int n = 2011;
        try {
            n = Integer.parseInt(this.erabox.getText());
        }
        catch (Exception exception) {
            this.statusLabel.setText("Era year is not valid.  --  " + this.statusLabel.getText());
            this.erabox.setText("" + this.eraYears[this.theMech.era][2]);
            n = this.eraYears[this.theMech.era][2];
        }
        if (n < this.eraYears[this.theMech.era][0]) {
            this.erabox.setText("" + this.eraYears[this.theMech.era][0]);
        }
        if (n > this.eraYears[this.theMech.era][1]) {
            this.erabox.setText("" + this.eraYears[this.theMech.era][1]);
        }
        this.sheetPanel.refreshImage();
        this.theMech.drawCrits();
        this.theMech.drawList();
        this.theMech.drawRadars();
        this.theMech.drawDots();
        this.theMech.drawRestOfForm();
    }

    private void replaceComboItems(JComboBox jComboBox, String[] stringArray) {
        jComboBox.removeAllItems();
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
    }

    private int ylev(double d) {
        return (int)(24.0 * d) + 15;
    }

    private int minimum(int n, int n2, int n3) {
        return Math.min(Math.min(n, n2), n3);
    }

    private void initComponents() {
        JScrollPane jScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        jScrollPane.setViewportView(this.mainPanel);
        Container container = this.frame.getContentPane();
        container.add(jScrollPane);
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setBackground(this.backCol);
        this.mainPanel.setPreferredSize(new Dimension(1474, 875));
        this.mainPanel.setLayout(null);
        jScrollPane.setBounds(0, 0, 1474, 875);
        this.sheetPanel.setBackground(Color.red);
        this.mainPanel.add(this.sheetPanel);
        this.sheetPanel.setBounds(2, 2, 782, 869);
        this.statusLabel.setText("Right-click items in list to add them. Right-click mounted items on sheet to edit/remove them.");
        this.mainPanel.add(this.statusLabel);
        this.statusLabel.setForeground(Color.blue);
        this.statusLabel.setBounds(790, 0, 1000, 20);
        this.weapsTreeScrollPane = new JScrollPane();
        this.weapsTree = new MyWeaponsTree(this, this.theMech, new MyCustomMutableTreeNode((Object)"Weapons and Equipment       Ht  Dam  Mi/Sh/Me/Lo  Am Wgt Cr", "root.png"), "isWeapons");
        this.weapsTree.setToggleClickCount(1);
        this.weapsTreeScrollPane.setViewportView(this.weapsTree);
        this.mainPanel.add(this.weapsTreeScrollPane);
        this.weapsTreeScrollPane.setBounds(1038, 19, 434, 705);
        this.twoLegRadio = new JRadioButton("Biped", true);
        this.fourLegRadio = new JRadioButton("Quad", false);
        this.structureGroup = new ButtonGroup();
        this.twoLegRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedTwoLegRadio();
            }
        });
        this.fourLegRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedFourLegRadio();
            }
        });
        this.mainPanel.add(this.twoLegRadio);
        this.mainPanel.add(this.fourLegRadio);
        this.twoLegRadio.setBounds(790, this.ylev(0.0) + 2, 110, 20);
        this.fourLegRadio.setBounds(790, this.ylev(1.0) - 2, 110, 20);
        this.structureGroup.add(this.twoLegRadio);
        this.structureGroup.add(this.fourLegRadio);
        this.isRadio = new JRadioButton("Inner Sphere", true);
        this.clanRadio = new JRadioButton("Clan", false);
        this.techBaseGroup = new ButtonGroup();
        this.isRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedIsRadio(true);
            }
        });
        this.clanRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedClanRadio();
            }
        });
        this.mainPanel.add(this.isRadio);
        this.mainPanel.add(this.clanRadio);
        this.isRadio.setBounds(910, this.ylev(0.0) + 2, 110, 20);
        this.clanRadio.setBounds(910, this.ylev(1.0) - 2, 110, 20);
        this.techBaseGroup.add(this.isRadio);
        this.techBaseGroup.add(this.clanRadio);
        this.omniBox = new JCheckBox("Omni");
        this.omniBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedOmniBox();
            }
        });
        this.omniBox.setSelected(false);
        this.omniBox.setBounds(790, this.ylev(2.0), 110, 20);
        this.mainPanel.add(this.omniBox);
        this.eraLabel = new JLabel("Year:");
        this.erabox = new JTextField("3085");
        this.eraCombo = new JComboBox<String>(this.eras);
        this.eraCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedEra(BtMechBuilder.this.eraCombo.getSelectedIndex());
            }
        });
        this.mainPanel.add(this.eraLabel);
        this.mainPanel.add(this.erabox);
        this.mainPanel.add(this.eraCombo);
        this.erabox.setBounds(965, this.ylev(2.0), 55, 20);
        this.eraLabel.setBounds(930, this.ylev(2.0), 30, 20);
        this.eraCombo.setBounds(790, this.ylev(3.0), 200, 20);
        this.lockButton = new JButton(" Lock ");
        this.lockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedLock();
            }
        });
        this.mainPanel.add(this.lockButton);
        this.lockButton.setBounds(965, this.ylev(4.0), 55, 20);
        this.nameField = new JTextField("Name");
        this.variantField = new JTextField("Variant");
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.changedName(BtMechBuilder.this.nameField.getText());
            }
        });
        this.variantField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.changedVar(BtMechBuilder.this.variantField.getText());
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BtMechBuilder.this.changedName(BtMechBuilder.this.nameField.getText());
            }
        });
        this.variantField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                BtMechBuilder.this.changedVar(BtMechBuilder.this.variantField.getText());
            }
        });
        this.mainPanel.add(this.nameField);
        this.mainPanel.add(this.variantField);
        this.nameField.setBounds(790, this.ylev(5.0), 110, 20);
        this.variantField.setBounds(910, this.ylev(5.0), 110, 20);
        this.tonnageCombo = new JComboBox<String>(this.tonnages);
        this.tonnageCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedTonnage((String)BtMechBuilder.this.tonnageCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.tonnageCombo);
        this.tonnageCombo.setBounds(790, this.ylev(4.0), 110, 20);
        this.standardStructRadio = new JRadioButton("Std. Structure", true);
        this.endoRadio = new JRadioButton("Endo Steel", false);
        this.internalStructGroup = new ButtonGroup();
        this.standardStructRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedStandardStructRadio();
            }
        });
        this.endoRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedEndoRadio();
            }
        });
        this.mainPanel.add(this.standardStructRadio);
        this.mainPanel.add(this.endoRadio);
        this.standardStructRadio.setBounds(790, this.ylev(6.0) + 2, 110, 20);
        this.endoRadio.setBounds(790, this.ylev(7.0) - 2, 110, 20);
        this.internalStructGroup.add(this.standardStructRadio);
        this.internalStructGroup.add(this.endoRadio);
        this.walksCombo = new JComboBox<String>(this.walks);
        this.walksCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedWalk((String)BtMechBuilder.this.walksCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.walksCombo);
        this.walksCombo.setBounds(790, this.ylev(8.0), 110, 20);
        this.engineCombo = new JComboBox<String>(this.isEngines);
        this.engineCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedEngine((String)BtMechBuilder.this.engineCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.engineCombo);
        this.engineCombo.setBounds(790, this.ylev(9.0), 160, 20);
        this.gyroCombo = new JComboBox<String>(this.isGyros);
        this.gyroCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedGyro((String)BtMechBuilder.this.gyroCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.gyroCombo);
        this.gyroCombo.setBounds(790, this.ylev(10.0), 160, 20);
        this.cockpitCombo = new JComboBox<String>(this.isCockpits);
        this.cockpitCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedCockpit((String)BtMechBuilder.this.cockpitCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.cockpitCombo);
        this.cockpitCombo.setBounds(790, this.ylev(11.0), 160, 20);
        this.tsmBox = new JCheckBox("Triple Strength Myomer");
        this.tsmBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedTSM();
            }
        });
        this.mainPanel.add(this.tsmBox);
        this.tsmBox.setBounds(790, this.ylev(12.0), 200, 20);
        this.leftArmBox = new JCheckBox("Left Lower Arm Actuator", true);
        this.leftHandBox = new JCheckBox("Left Hand Actuator", true);
        this.rightArmBox = new JCheckBox("Right Lower Arm Actuator", true);
        this.rightHandBox = new JCheckBox("Right Hand Actuator", true);
        this.leftArmBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedLeftArm();
            }
        });
        this.leftHandBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedLeftHand();
            }
        });
        this.rightArmBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedRightArm();
            }
        });
        this.rightHandBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedRightHand();
            }
        });
        this.mainPanel.add(this.leftArmBox);
        this.mainPanel.add(this.leftHandBox);
        this.mainPanel.add(this.rightArmBox);
        this.mainPanel.add(this.rightHandBox);
        this.leftArmBox.setBounds(790, this.ylev(13.0), 200, 20);
        this.leftHandBox.setBounds(790, this.ylev(14.0), 200, 20);
        this.rightArmBox.setBounds(790, this.ylev(15.0), 200, 20);
        this.rightHandBox.setBounds(790, this.ylev(16.0), 200, 20);
        this.stdHSRadio = new JRadioButton("Standard HeatSinks", true);
        this.dblHSRadio = new JRadioButton("Double HeatSinks", false);
        this.hsGroup = new ButtonGroup();
        this.hsSpin = new JSpinner(new SpinnerNumberModel(10, 10, 23, 1));
        this.hsLabel = new JLabel("HS");
        this.stdHSRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedStdHSRadio();
            }
        });
        this.dblHSRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedDblHSRadio();
            }
        });
        this.hsSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedHsSpin();
            }
        });
        this.mainPanel.add(this.stdHSRadio);
        this.mainPanel.add(this.dblHSRadio);
        this.mainPanel.add(this.hsSpin);
        this.mainPanel.add(this.hsLabel);
        this.stdHSRadio.setBounds(790, this.ylev(17.0) + 2, 150, 20);
        this.dblHSRadio.setBounds(790, this.ylev(18.0) - 2, 150, 20);
        this.hsSpin.setBounds(950, this.ylev(18.0), 50, 20);
        this.hsLabel.setBounds(1005, this.ylev(18.0), 30, 20);
        this.hsGroup.add(this.stdHSRadio);
        this.hsGroup.add(this.dblHSRadio);
        this.armourCombo = new JComboBox<String>(this.isArmours);
        this.armourCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedArmour((String)BtMechBuilder.this.armourCombo.getSelectedItem());
            }
        });
        this.mainPanel.add(this.armourCombo);
        this.armourCombo.setBounds(790, this.ylev(19.0), 210, 20);
        this.amrFillBtn = new JButton("Auto-Fill");
        this.amrFillBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedAutoFill();
            }
        });
        this.mainPanel.add(this.amrFillBtn);
        this.amrFillBtn.setBounds(970, this.ylev(21.0), 60, 20);
        this.amrClearBtn = new JButton("Clear");
        this.amrClearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedAutoClear();
            }
        });
        this.mainPanel.add(this.amrClearBtn);
        this.amrClearBtn.setBounds(970, this.ylev(22.0), 60, 20);
        this.addAmrBtn = new JButton("+0.5t");
        this.addAmrBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedAddAmr();
            }
        });
        this.mainPanel.add(this.addAmrBtn);
        this.addAmrBtn.setBounds(970, this.ylev(23.0), 60, 20);
        this.subAmrBtn = new JButton("-0.5t");
        this.subAmrBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedSubAmr();
            }
        });
        this.mainPanel.add(this.subAmrBtn);
        this.subAmrBtn.setBounds(970, this.ylev(24.0), 60, 20);
        this.armourLabel2 = new JLabel("Amour: " + this.theMech.armourTons + "/" + this.theMech.maxArmTons + " tons.  " + this.theMech.armourPts + "/" + this.theMech.maxArmour + " pts.");
        this.mainPanel.add(this.armourLabel2);
        this.armourLabel2.setBounds(790, this.ylev(20.0), 240, 20);
        this.armHLabel = new JLabel("/" + this.theMech.locMaxArmour[0] + ") Head");
        this.armLTLabel = new JLabel("/" + this.theMech.locMaxArmour[1] + ") Left Torso");
        this.armCTLabel = new JLabel("/" + this.theMech.locMaxArmour[2] + ") Centre Torso");
        this.armRTLabel = new JLabel("/" + this.theMech.locMaxArmour[3] + ") Right Torso");
        this.armRearLTLabel = new JLabel("/" + this.theMech.locMaxArmour[8] + ") Rear LT");
        this.armRearCTLabel = new JLabel("/" + this.theMech.locMaxArmour[9] + ") Rear CT");
        this.armRearRTLabel = new JLabel("/" + this.theMech.locMaxArmour[10] + ") Rear RT");
        this.armLALabel = new JLabel("/" + this.theMech.locMaxArmour[4] + ") Left Arm");
        this.armRALabel = new JLabel("/" + this.theMech.locMaxArmour[5] + ") Right Arm");
        this.armLLLabel = new JLabel("/" + this.theMech.locMaxArmour[6] + ") Left Leg");
        this.armRLLabel = new JLabel("/" + this.theMech.locMaxArmour[7] + ") Right Leg");
        this.armHSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[0], 1));
        this.armLTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[1], 1));
        this.armCTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[2], 1));
        this.armRTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[3], 1));
        this.armRearLTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[8], 1));
        this.armRearCTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[9], 1));
        this.armRearRTSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[10], 1));
        this.armLASpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[4], 1));
        this.armRASpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[5], 1));
        this.armLLSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[6], 1));
        this.armRLSpin = new JSpinner(new SpinnerNumberModel(0, 0, this.theMech.locMaxArmour[7], 1));
        this.armHSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmHSpin();
            }
        });
        this.armLTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmLTSpin();
            }
        });
        this.armCTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmCTSpin();
            }
        });
        this.armRTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRTSpin();
            }
        });
        this.armRearLTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRearLTSpin();
            }
        });
        this.armRearCTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRearCTSpin();
            }
        });
        this.armRearRTSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRearRTSpin();
            }
        });
        this.armLASpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmLASpin();
            }
        });
        this.armRASpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRASpin();
            }
        });
        this.armLLSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmLLSpin();
            }
        });
        this.armRLSpin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BtMechBuilder.this.pressedArmRLSpin();
            }
        });
        this.mainPanel.add(this.armHSpin);
        this.mainPanel.add(this.armHLabel);
        this.mainPanel.add(this.armLTSpin);
        this.mainPanel.add(this.armLTLabel);
        this.mainPanel.add(this.armCTSpin);
        this.mainPanel.add(this.armCTLabel);
        this.mainPanel.add(this.armRTSpin);
        this.mainPanel.add(this.armRTLabel);
        this.mainPanel.add(this.armRearLTSpin);
        this.mainPanel.add(this.armRearLTLabel);
        this.mainPanel.add(this.armRearCTSpin);
        this.mainPanel.add(this.armRearCTLabel);
        this.mainPanel.add(this.armRearRTSpin);
        this.mainPanel.add(this.armRearRTLabel);
        this.mainPanel.add(this.armLASpin);
        this.mainPanel.add(this.armLALabel);
        this.mainPanel.add(this.armRASpin);
        this.mainPanel.add(this.armRALabel);
        this.mainPanel.add(this.armLLSpin);
        this.mainPanel.add(this.armLLLabel);
        this.mainPanel.add(this.armRLSpin);
        this.mainPanel.add(this.armRLLabel);
        this.armHSpin.setBounds(790, this.ylev(21.0), 55, 20);
        this.armHLabel.setBounds(850, this.ylev(21.0), 180, 20);
        this.armLTSpin.setBounds(790, this.ylev(22.0) + 1, 55, 20);
        this.armLTLabel.setBounds(850, this.ylev(22.0), 180, 20);
        this.armCTSpin.setBounds(790, this.ylev(24.0) + 1, 55, 20);
        this.armCTLabel.setBounds(850, this.ylev(24.0), 180, 20);
        this.armRTSpin.setBounds(790, this.ylev(26.0) + 1, 55, 20);
        this.armRTLabel.setBounds(850, this.ylev(26.0), 180, 20);
        this.armRearLTSpin.setBounds(790, this.ylev(23.0) - 1, 55, 20);
        this.armRearLTLabel.setBounds(850, this.ylev(23.0), 180, 20);
        this.armRearCTSpin.setBounds(790, this.ylev(25.0) - 1, 55, 20);
        this.armRearCTLabel.setBounds(850, this.ylev(25.0), 180, 20);
        this.armRearRTSpin.setBounds(790, this.ylev(27.0) - 1, 55, 20);
        this.armRearRTLabel.setBounds(850, this.ylev(27.0), 180, 20);
        this.armLASpin.setBounds(790, this.ylev(28.0), 55, 20);
        this.armLALabel.setBounds(850, this.ylev(28.0), 180, 20);
        this.armRASpin.setBounds(790, this.ylev(29.0), 55, 20);
        this.armRALabel.setBounds(850, this.ylev(29.0), 180, 20);
        this.armLLSpin.setBounds(790, this.ylev(30.0), 55, 20);
        this.armLLLabel.setBounds(850, this.ylev(30.0), 180, 20);
        this.armRLSpin.setBounds(790, this.ylev(31.0), 55, 20);
        this.armRLLabel.setBounds(850, this.ylev(31.0), 170, 20);
        this.saveBtn = new JButton("Save");
        this.loadBtn = new JButton("Load");
        this.aboutBtn = new JButton("Help");
        this.massLabel = new JLabel(this.theMech.currWeight + " / " + this.theMech.tonnage + "  Tons");
        this.critsLabel = new JLabel(this.theMech.totalCrits() - this.theMech.totalEmptyCrits() + " / " + this.theMech.totalCrits() + "  Crits");
        this.saveBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedSave();
            }
        });
        this.loadBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedLoad();
            }
        });
        this.aboutBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedAbout();
            }
        });
        this.mainPanel.add(this.saveBtn);
        this.mainPanel.add(this.loadBtn);
        this.mainPanel.add(this.aboutBtn);
        this.mainPanel.add(this.massLabel);
        this.mainPanel.add(this.critsLabel);
        this.saveBtn.setBounds(980, this.ylev(29.0), 50, 40);
        this.loadBtn.setBounds(980, this.ylev(31.0) - 3, 50, 40);
        this.aboutBtn.setBounds(980, this.ylev(33.0) - 6, 50, 40);
        this.massLabel.setBounds(790, this.ylev(32.0), 200, 48);
        this.critsLabel.setBounds(790, this.ylev(33.0), 200, 48);
        this.massLabel.setFont(new Font("SansSerif", 1, 18));
        this.critsLabel.setFont(new Font("SansSerif", 1, 18));
        this.critsLabel.setForeground(Color.black);
        this.massLabel.setForeground(Color.black);
        this.saveLabel = new JLabel("");
        this.mainPanel.add(this.saveLabel);
        this.saveLabel.setBounds(790, this.ylev(35.0), 660, 20);
        this.saveLabel.setForeground(Color.red);
        this.diagramPanel.setBackground(Color.red);
        this.mainPanel.add(this.diagramPanel);
        this.diagramPanel.setBounds(1038, 725, 434, 128);
        this.hideButton = new JButton("|");
        this.mainPanel.add(this.hideButton);
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BtMechBuilder.this.pressedHide();
            }
        });
        this.hideButton.setBounds(1450, this.ylev(35.0) - 3, 24, 24);
    }

    private void loadMtfNames() {
        MyTextLine myTextLine;
        this.mtfNames = new ArrayList();
        MyTextReader myTextReader = new MyTextReader("mtfNames");
        while ((myTextLine = myTextReader.nextLine(true)) != null) {
            String string;
            ArrayList<String> arrayList = new ArrayList<String>();
            boolean bl = false;
            int n = 0;
            while ((string = myTextLine.nextToken()) != null) {
                if (string.contains("xperimental")) {
                    bl = true;
                }
                if (string.contains("nofficial")) {
                    bl = true;
                }
                if (++n <= 3) continue;
                arrayList.add(string);
            }
            if (bl) continue;
            this.mtfNames.add(arrayList);
        }
    }

    public BtMechBuilder() {
        Object object;
        this.loadMtfNames();
        this.statusLabel = new JLabel();
        this.diagramPanel = new MyDiagPanel("diagrams.png");
        this.sheetPanel = new MyDrawPanel("twoLegForm.png", "twoLegFormLocs", this.diagramPanel);
        this.theMech = new Mech(this.statusLabel, this.sheetPanel, this);
        this.sheetPanel.setMech(this, this.theMech);
        this.backCol = new Color(170, 190, 190);
        Color color = new Color(210, 230, 230);
        this.isEngines = this.eraIsEngines[0];
        this.clanEngines = this.eraClanEngines[0];
        this.isGyros = this.eraIsGyros[0];
        this.clanGyros = this.eraClanGyros[0];
        this.isCockpits = this.eraIsCockpits[0];
        this.clanCockpits = this.eraClanCockpits[0];
        this.isArmours = this.eraIsArmours[0];
        this.clanArmours = this.eraClanArmours[0];
        UIManager.put("TextArea.font", new Font("SansSerif", 2, 12));
        UIManager.put("Tree.font", new Font("Lucida Sans Typewriter", 0, 10));
        UIManager.put("RadioButton.background", this.backCol);
        UIManager.put("CheckBox.background", this.backCol);
        UIManager.put("TextArea.background", color);
        UIManager.put("TextArea.font", new Font("SansSerif", 0, 14));
        UIManager.put("Table.font", new Font("SansSerif", 0, 8));
        UIManager.put("ToggleButton.font", new Font("SansSerif", 0, 12));
        UIManager.put("Button.font", new Font("SansSerif", 0, 12));
        UIManager.put("Button.margin", new Insets(1, 1, 1, 1));
        UIManager.put("ToggleButton.margin", new Insets(1, 1, 1, 1));
        this.frame = new JFrame("QuickMech v0.4");
        this.frame.setDefaultCloseOperation(3);
        try {
            this.frame.setIconImage(ImageIO.read(new File("icon.png")));
        }
        catch (Exception exception) {
            try {
                object = this.getClass().getClassLoader().getResourceAsStream("icon.png");
                this.frame.setIconImage(ImageIO.read((InputStream)object));
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        this.initComponents();
        this.validityChecks();
        this.frame.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        object = toolkit.getScreenSize();
        Dimension dimension = this.frame.getSize();
        this.frame.setLocation((int)(((Dimension)object).getWidth() - (double)this.frame.getWidth()) / 2, (int)(((Dimension)object).getHeight() - (double)this.frame.getHeight()) / 2);
        this.frame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        BtMechBuilder btMechBuilder = new BtMechBuilder();
    }

    class MyFilter
    extends FileFilter {
        MyFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            if (string.endsWith(".mtf")) {
                return true;
            }
            if (string.endsWith(".MTF")) {
                return true;
            }
            if (string.endsWith(".Mtf")) {
                return true;
            }
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.mtf  ,  *.MTF";
        }
    }
}

