/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;

public class BVlist {
    LinkedList<BVitem> list;
    boolean[] cased;
    GetCosters getCost;
    GetBVers getBV;
    GetHeaters getHeat;
    GetCriters getCrit;
    Mech theMech;
    boolean tc;

    public BVlist(Mech mech, boolean[] blArray, GetHeaters getHeaters, GetCosters getCosters, GetBVers getBVers, GetCriters getCriters, boolean bl) {
        this.theMech = mech;
        this.getCost = getCosters;
        this.getBV = getBVers;
        this.getHeat = getHeaters;
        this.getCrit = getCriters;
        this.tc = bl;
        this.list = new LinkedList();
        this.cased = blArray;
    }

    public void add(Mount mount, int n) {
        BVitem bVitem;
        int n2;
        int n3 = 0;
        if (mount.rearFacing) {
            n3 = 1;
        }
        if ((n2 = this.indexOf(this.list, bVitem = new BVitem(mount.i.id, n, n3))) == -1) {
            this.list.add(bVitem);
            if (n < 4) {
                bVitem.cased = this.cased[n];
            }
            bVitem.heat = this.getHeat.get(mount.i);
            if (bVitem.id.contains("OS") || bVitem.id.contains("RL1") || bVitem.id.contains("RL2")) {
                bVitem.heat *= 0.25;
            }
            if (bVitem.id.contains("Streak")) {
                bVitem.heat *= 0.5;
            }
            bVitem.cost = this.getCost.get(mount.i, n);
            bVitem.unModifiedBV = this.getBV.get(mount.i);
            bVitem.crits = this.getCrit.get(mount.i);
            if (this.tc && mount.i.directFire > 0) {
                bVitem.targCompModifier = 1.25;
            }
            bVitem.ranges = "" + String.format("%-3s", " " + mount.i.min) + String.format("%-3s", " " + mount.i.sht) + String.format("%-3s", " " + mount.i.med) + String.format("%-3s", " " + mount.i.lng);
            bVitem.dam = mount.i.damage;
            bVitem.name = mount.i.getName();
            bVitem.listedHeat = mount.i.heat;
            ArrayList<String> arrayList = mount.i.ammoTypes;
            for (int i = 0; i < arrayList.size(); ++i) {
                int n4 = this.theMech.countItem(arrayList.get(i));
                Item item = this.theMech.window.findItem(arrayList.get(i), false);
                double d = this.getBV.get(item);
                bVitem.ammoTotalBV += (double)n4 * d;
            }
        } else {
            bVitem = this.list.get(n2);
            ++bVitem.quantity;
        }
    }

    public double getTotalModifiedBV() {
        return this.getTotalModifiedBV(9.9999999E7);
    }

    public double getTotalModifiedBV(double d) {
        Collections.sort(this.list);
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.list.size(); ++i) {
            BVitem bVitem = this.list.get(i);
            for (int j = 0; j < bVitem.quantity; ++j) {
                double d4 = bVitem.getSingleModifiedBV();
                if (bVitem.heat > 0.0 && d3 >= d) {
                    d4 *= 0.5;
                }
                d2 += d4;
                d3 += bVitem.heat;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BVitem bVitem : this.list) {
            if (arrayList.contains(bVitem.id)) continue;
            arrayList.add(bVitem.id);
            d2 += bVitem.ammoTotalBV;
        }
        return d2;
    }

    public void trimExcessiveAmmo() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (BVitem bVitem : this.list) {
            if (arrayList.contains(bVitem.id)) continue;
            double d = 0.0;
            for (BVitem bVitem2 : this.list) {
                if (!bVitem2.id.equals(bVitem.id)) continue;
                d += 1.0;
            }
            arrayList2.add(d);
            arrayList.add(bVitem.id);
        }
        for (BVitem bVitem : this.list) {
            if (!(bVitem.ammoTotalBV > (Double)arrayList2.get(arrayList.indexOf(bVitem.id)) * bVitem.unModifiedBV)) continue;
            bVitem.ammoTotalBV = (int)((double)bVitem.quantity * bVitem.unModifiedBV);
        }
    }

    public void swapFireArcs() {
        int n = 0;
        int n2 = 0;
        for (BVitem bVitem : this.list) {
            if (bVitem.rearFacing == 0) {
                n += (int)bVitem.unModifiedBV;
                continue;
            }
            n2 += (int)bVitem.unModifiedBV;
        }
        if (n >= n2) {
            return;
        }
        for (BVitem bVitem : this.list) {
            if (bVitem.rearFacing == 0) {
                bVitem.rearFacing = 2;
            }
            if (bVitem.rearFacing != 1) continue;
            bVitem.rearFacing = 0;
        }
        for (BVitem bVitem : this.list) {
            if (bVitem.rearFacing != 2) continue;
            bVitem.rearFacing = 1;
        }
    }

    private int indexOf(LinkedList<BVitem> linkedList, BVitem bVitem) {
        for (int i = 0; i < linkedList.size(); ++i) {
            if (!linkedList.get(i).equals(bVitem)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        String string = "&&&>>>>>>>>>>>>>>>>>>>>\n";
        for (BVitem bVitem : this.list) {
            string = string + bVitem.toString() + "\n";
        }
        string = string + "&&&<<<<<<<<<<<<<<<<<<<<<<\n";
        return string;
    }
}

