/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

public class Adders {
    private final int H = 0;
    private final int LT = 1;
    private final int CT = 2;
    private final int RT = 3;
    private final int LA = 4;
    private final int RA = 5;
    private final int LL = 6;
    private final int RL = 7;
    private final int rLT = 8;
    private final int rCT = 9;
    private final int rRT = 10;
    Mech theMech;
    BtMechBuilder window;
    GetCriters getCrit;

    public Adders(BtMechBuilder btMechBuilder, Mech mech) {
        this.theMech = mech;
        this.window = btMechBuilder;
        this.getCrit = this.theMech.getCrit;
    }

    public void add(Item item, int n, int n2, int n3) {
        if (item.id.equals("ISHeavyGaussRifle")) {
            this.heavyGauss(item, n, n2, n3);
        } else if (item.id.equals("ISMASC")) {
            this.masc(item, n);
        } else if (item.id.equals("ART4 LRM 5") || item.id.equals("ART4 LRM 10") || item.id.equals("ART4 LRM 15") || item.id.equals("ART4 LRM 20") || item.id.equals("ART4 SRM 2") || item.id.equals("ART4 SRM 4") || item.id.equals("ART4 SRM 6") || item.id.equals("ART4 LRM 5 (OS)") || item.id.equals("ART4 LRM 10 (OS)") || item.id.equals("ART4 LRM 15 (OS)") || item.id.equals("ART4 LRM 20 (OS)") || item.id.equals("ART4 ISSRM2OS") || item.id.equals("ART4 ISSRM4OS") || item.id.equals("ART4 ISSRM6OS") || item.id.equals("ART4 CLLRM5") || item.id.equals("ART4 CLLRM10") || item.id.equals("ART4 CLLRM15") || item.id.equals("ART4 CLLRM20") || item.id.equals("ART4 CLSRM2") || item.id.equals("ART4 CLSRM4") || item.id.equals("ART4 CLSRM6") || item.id.equals("ART4 CLLRM5 (OS)") || item.id.equals("ART4 CLLRM10 (OS)") || item.id.equals("ART4 CLLRM15 (OS)") || item.id.equals("ART4 CLLRM20 (OS)") || item.id.equals("ART4 CLSRM2 (OS)") || item.id.equals("ART4 CLSRM4 (OS)") || item.id.equals("ART4 CLSRM6 (OS)")) {
            this.art4s(item, n);
        } else if (item.id.equals("ISMML3") || item.id.equals("ISMML5") || item.id.equals("ISMML7") || item.id.equals("ISMML9") || item.id.equals("ART4 ISMML3") || item.id.equals("ART4 ISMML5") || item.id.equals("ART4 ISMML7") || item.id.equals("ART4 ISMML9")) {
            this.mml(item, n);
        } else if (item.id.equals("CLATM3") || item.id.equals("CLATM6") || item.id.equals("CLATM9") || item.id.equals("CLATM12")) {
            this.atm(item, n);
        } else if (item.id.equals("ISLBXAC20") || item.id.equals("Autocannon/20") || item.id.equals("ISUltraAC20") || item.id.equals("CLLBXAC20") || item.id.equals("CLUltraAC20")) {
            this.ac20s(item, n, n2, n3);
        } else {
            this.defaultAdd(item, n);
        }
        this.window.validityChecks();
    }

    private int defaultAdd(Item item, int n) {
        int n2;
        int n3;
        Color color = this.theMech.weaponCol;
        if (!item.isWeapon) {
            color = this.theMech.nonWeapCol;
        }
        if (item.isAmmo) {
            color = this.theMech.ammoCol;
        }
        if (!item.showInList) {
            color = this.theMech.movableCol;
        }
        if ((n3 = this.getCrit.get(item)) > (n2 = this.theMech.locs[n].critsLeft())) {
            int n4;
            String[] stringArray = new String[]{"TSM", "Endo Steel", "Ferro-Fibrous", "Heavy Ferro-Fibrous", "Light Ferro-Fibrous"};
            for (n4 = n2; n4 < n3; ++n4) {
                int n5 = this.theMech.locs[n].getLastArray(stringArray);
                if (n5 == -1) continue;
                this.theMech.locs[n].slide(n5);
            }
            n4 = this.theMech.locs[n].push(new Mount(item, n3, color));
            this.theMech.update();
            return n4;
        }
        return this.theMech.locs[n].push(new Mount(item, n3, color));
    }

    private void masc(Item item, int n) {
        this.window.tsmBox.setEnabled(false);
        this.defaultAdd(item, n);
    }

    private void art4s(Item item, int n) {
        Item item2 = new Item(item);
        int n2 = item2.name.indexOf(" +");
        if (n2 > -1) {
            item2.name = item2.name.substring(0, n2);
        }
        int n3 = this.defaultAdd(item2, n);
        Item item3 = null;
        if (this.theMech.isClan) {
            item3 = new Item("CLArtemisIV");
        }
        if (!this.theMech.isClan) {
            item3 = new Item("ISArtemisIV");
        }
        item3.name = "Artemis IV";
        Mount mount = this.theMech.locs[n].crits[n3 + this.getCrit.get(item2) - 1];
        mount.i = item3;
    }

    private void atm(Item item, int n) {
        this.theMech.msgLabel.setText("ATMs will not update the damage diagram without ammo.  --  " + this.theMech.msgLabel.getText());
        this.defaultAdd(item, n);
    }

    private void mml(Item item, int n) {
        this.theMech.msgLabel.setText("MMLs will not update the damage diagram without ammo.  --  " + this.theMech.msgLabel.getText());
        if (item.id.startsWith("ART4 ")) {
            this.art4s(item, n);
        } else {
            this.defaultAdd(item, n);
        }
    }

    private void ac20s(Item item, int n) {
        this.ac20s(item, n, -1, -1);
    }

    public void ac20s(Item item, int n, int n2, int n3) {
        if (n2 == -1 && this.theMech.locs[n].critsLeft() >= this.getCrit.get(item)) {
            this.defaultAdd(item, n);
            return;
        }
        int n4 = 2;
        switch (n) {
            case 4: 
            case 6: {
                n4 = 1;
                break;
            }
            case 5: 
            case 7: {
                n4 = 3;
            }
        }
        int n5 = this.theMech.locs[n].critsLeft();
        int n6 = this.getCrit.get(item) - n5;
        if (n2 != -1) {
            n5 = n2;
        }
        if (n3 != -1) {
            n6 = n3;
        }
        if (n == 3 || n == 1) {
            Mount mount = new Mount(item, n5, this.theMech.weaponCol, item.name);
            this.theMech.locs[n].push(mount);
            Mount mount2 = new Mount(item, n6, this.theMech.weaponCol, item.name);
            this.theMech.locs[n4].push(mount2);
            mount2.col = this.getFadedCol(mount.col);
            mount2.split = true;
            mount2.partner = mount;
            mount2.partnerLoc = n;
            mount.partner = mount2;
            mount.partnerLoc = n4;
        } else {
            Mount mount = new Mount(item, n6, this.theMech.weaponCol, item.name);
            this.theMech.locs[n4].push(mount);
            Mount mount3 = new Mount(item, n5, this.theMech.weaponCol, item.name);
            this.theMech.locs[n].push(mount3);
            mount3.col = this.getFadedCol(mount.col);
            mount3.split = true;
            mount3.partner = mount;
            mount3.partnerLoc = n4;
            mount.partner = mount3;
            mount.partnerLoc = n;
        }
    }

    private void heavyGauss(Item item, int n) {
        this.heavyGauss(item, n, -1, -1);
    }

    private void heavyGauss(Item item, int n, int n2, int n3) {
        if (n2 == -1 && this.theMech.locs[n].critsLeft() >= this.getCrit.get(item)) {
            this.defaultAdd(item, n);
            return;
        }
        int n4 = this.theMech.locs[n].critsLeft();
        int n5 = this.getCrit.get(item) - n4;
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        Mount mount = new Mount(item, n4, this.theMech.weaponCol, item.name);
        this.theMech.locs[n].push(mount);
        Mount mount2 = new Mount(item, n5, this.theMech.weaponCol, item.name);
        mount2.split = true;
        this.theMech.locs[2].push(mount2);
        mount2.col = this.getFadedCol(mount.col);
        mount2.partner = mount;
        mount2.partnerLoc = n;
        mount.partner = mount2;
        mount.partnerLoc = 2;
    }

    private Color getFadedCol(Color color) {
        int n = color.getGreen();
        int n2 = color.getRed();
        int n3 = color.getBlue();
        n = 128 + n / 2;
        n2 = 128 + n2 / 2;
        n3 = 128 + n3 / 2;
        return new Color(n2, n, n3);
    }
}

